/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class RoleType
implements ResourceType<Role> {
    private final MixedOperation<Role, RoleList, Resource<Role>> client = KubeResourceManager.get().kubeClient().getClient().rbac().roles();

    public String getKind() {
        return "Role";
    }

    public void create(Role resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void update(Role resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Role resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Role resource, Consumer<Role> editor) {
        Role toBeUpdated = (Role)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(Role resource) {
        return resource != null;
    }

    public boolean isDeleted(Role resource) {
        return resource == null;
    }
}

