/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class DeploymentType
implements ResourceType<Deployment> {
    private final MixedOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>> client = KubeResourceManager.getKubeClient().getClient().apps().deployments();

    public String getKind() {
        return "Deployment";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Deployment resource) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(Deployment resource) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Deployment resource) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Deployment resource, Consumer<Deployment> editor) {
        Deployment toBeUpdated = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(Deployment resource) {
        return ((RollableScalableResource)this.client.resource((Object)resource)).isReady();
    }

    public boolean isDeleted(Deployment resource) {
        return resource == null;
    }
}

