/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class RoleBindingType
implements ResourceType<RoleBinding> {
    private final MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> client = KubeResourceManager.getKubeClient().getClient().rbac().roleBindings();

    public String getKind() {
        return "RoleBinding";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(RoleBinding resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(RoleBinding resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(RoleBinding resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(RoleBinding resource, Consumer<RoleBinding> editor) {
        RoleBinding toBeUpdated = (RoleBinding)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(RoleBinding resource) {
        return resource != null;
    }

    public boolean isDeleted(RoleBinding resource) {
        return resource == null;
    }
}

