/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ServiceType
implements ResourceType<Service> {
    private final MixedOperation<Service, ServiceList, ServiceResource<Service>> client = KubeResourceManager.getKubeClient().getClient().services();

    public String getKind() {
        return "Service";
    }

    public void create(Service resource) {
        ((ServiceResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void update(Service resource) {
        ((ServiceResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Service resource) {
        ((ServiceResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Service resource, Consumer<Service> editor) {
        Service toBeReplaced = (Service)((ServiceResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(Service resource) {
        return resource != null;
    }

    public boolean isDeleted(Service resource) {
        return resource == null;
    }
}

