/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class JobType
implements ResourceType<Job> {
    private final MixedOperation<Job, JobList, ScalableResource<Job>> client = KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs();

    public String getKind() {
        return "Job";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Job resource) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(Job resource) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Job resource) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Job resource, Consumer<Job> editor) {
        Job toBeUpdated = (Job)((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(Job resource) {
        return ((ScalableResource)this.client.resource((Object)resource)).isReady();
    }

    public boolean isDeleted(Job resource) {
        return resource == null;
    }
}

