/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class LeaseType
implements ResourceType<Lease> {
    private final MixedOperation<Lease, LeaseList, Resource<Lease>> client = KubeResourceManager.get().kubeClient().getClient().leases();

    public String getKind() {
        return "Lease";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Lease resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(Lease resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Lease resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Lease resource, Consumer<Lease> editor) {
        Lease toBeUpdated = (Lease)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(Lease resource) {
        return ((Resource)this.client.resource((Object)resource)).isReady();
    }

    public boolean isDeleted(Lease resource) {
        return resource == null;
    }
}

