/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ServiceAccountType
implements ResourceType<ServiceAccount> {
    private final MixedOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource> client = KubeResourceManager.get().kubeClient().getClient().serviceAccounts();

    public String getKind() {
        return "ServiceAccount";
    }

    public void create(ServiceAccount resource) {
        ((ServiceAccountResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void update(ServiceAccount resource) {
        ((ServiceAccountResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(ServiceAccount resource) {
        ((ServiceAccountResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(ServiceAccount resource, Consumer<ServiceAccount> editor) {
        ServiceAccount toBeReplaced = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(ServiceAccount resource) {
        return resource != null;
    }

    public boolean isDeleted(ServiceAccount resource) {
        return resource == null;
    }
}

