/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe;

import java.util.Locale;

public class LogCollectorUtils {
    private static final String YAML_TYPE = "yaml";
    private static final String LOG_TYPE = "log";

    private LogCollectorUtils() {
    }

    public static String getYamlFileNameForResource(String resourceName) {
        return LogCollectorUtils.getFileNameForResourceAndType(resourceName, YAML_TYPE);
    }

    public static String getLogFileNameForResource(String resourceName) {
        return LogCollectorUtils.getFileNameForResourceAndType(resourceName, LOG_TYPE);
    }

    public static String getLogFileNameForPodContainer(String podName, String containerName) {
        return LogCollectorUtils.getFileNameForResourceAndType(String.join((CharSequence)"-", "logs", "pod", podName, "container", containerName), LOG_TYPE);
    }

    public static String getLogFileNameForPodDescription(String podName) {
        return LogCollectorUtils.getFileNameForResourceAndType(String.join((CharSequence)"-", "describe", "pod", podName), LOG_TYPE);
    }

    private static String getFileNameForResourceAndType(String resourceName, String fileType) {
        return String.join((CharSequence)".", resourceName.toLowerCase(Locale.ROOT), fileType);
    }

    public static String getFullDirPathWithNamespace(String folderPath, String namespaceName) {
        return String.join((CharSequence)"/", folderPath, namespaceName);
    }

    public static String getNamespaceFullDirPathForResourceType(String namespaceFolderPath, String resourceType) {
        return String.join((CharSequence)"/", namespaceFolderPath, resourceType.toLowerCase(Locale.ROOT));
    }

    public static String getFullPathForFolderPathAndFileName(String folderPath, String fileName) {
        return String.join((CharSequence)"/", folderPath, fileName);
    }

    public static String getFolderPath(String rootPath, String folderPath) {
        if (folderPath == null) {
            return rootPath;
        }
        return String.join((CharSequence)"/", rootPath, folderPath);
    }
}

