/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.LogCollectorBuilder;
import io.skodjob.testframe.LogCollectorUtils;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.clients.cmdClient.Kubectl;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCollector.class);
    protected final List<String> namespacedResources;
    protected final List<String> clusterWideResources;
    protected String rootFolderPath;
    private KubeCmdClient<?> kubeCmdClient = new Kubectl();
    private KubeClient kubeClient = new KubeClient();

    public LogCollector(LogCollectorBuilder builder) {
        this.namespacedResources = builder.getNamespacedResources() == null ? Collections.emptyList() : builder.getNamespacedResources();
        List<Object> list = this.clusterWideResources = builder.getClusterWideResources() == null ? Collections.emptyList() : builder.getClusterWideResources();
        if (builder.getRootFolderPath() == null) {
            throw new RuntimeException("rootFolderPath should be filled, but it's empty");
        }
        if (builder.getKubeClient() != null) {
            this.kubeClient = builder.getKubeClient();
        }
        if (builder.getKubeCmdClient() != null) {
            this.kubeCmdClient = builder.getKubeCmdClient();
        }
        this.rootFolderPath = builder.getRootFolderPath();
    }

    public void collectFromNamespacesWithLabels(LabelSelector labelSelector) {
        this.collectFromNamespacesWithLabelsToFolder(labelSelector, null);
    }

    public void collectFromNamespacesWithLabelsToFolder(LabelSelector labelSelector, String folderPath) {
        List<String> namespacesWithLabel = ((NamespaceList)((FilterWatchListDeletable)this.kubeClient.getClient().namespaces().withLabelSelector(labelSelector)).list()).getItems().stream().map(namespace -> namespace.getMetadata().getName()).toList();
        namespacesWithLabel.forEach(namespace -> this.collectFromNamespaceToFolder((String)namespace, folderPath));
    }

    public void collectFromNamespaces(String ... namespacesNames) {
        this.collectFromNamespacesToFolder(Arrays.asList(namespacesNames), null);
    }

    public void collectFromNamespacesToFolder(List<String> namespacesNames, String folderPath) {
        namespacesNames.forEach(namespace -> this.collectFromNamespaceToFolder((String)namespace, folderPath));
    }

    public void collectFromNamespace(String namespaceName) {
        this.collectFromNamespaceToFolder(namespaceName, null);
    }

    public void collectClusterWideResources() {
        this.collectClusterWideResources(true);
    }

    public void collectClusterWideResources(boolean logPerResource) {
        this.collectClusterWideResourcesToFolder(logPerResource, null);
    }

    public void collectFromNamespaceToFolder(String namespaceName, String folderPath) {
        if (((Resource)this.kubeClient.getClient().namespaces().withName(namespaceName)).get() != null) {
            String namespaceFolderPath = this.createNamespaceDirectory(namespaceName, LogCollectorUtils.getFolderPath(this.rootFolderPath, folderPath));
            this.collectLogsFromPodsInNamespace(namespaceName, namespaceFolderPath);
            this.collectEventsFromNamespace(namespaceName, namespaceFolderPath);
            this.collectResourcesDescInNamespace(namespaceName, namespaceFolderPath);
        } else {
            LOGGER.warn("Specified Namespace: {} doesn't exist", (Object)namespaceName);
        }
    }

    public void collectClusterWideResourcesToFolder(String folderPath) {
        this.collectClusterWideResourcesToFolder(true, folderPath);
    }

    public void collectClusterWideResourcesToFolder(boolean logPerFile, String folderPath) {
        this.clusterWideResources.forEach(resourceType -> {
            LOGGER.info("Collecting YAMLs of {}", resourceType);
            String clusterWideFolderPath = this.createNamespaceDirectory("cluster-wide-resources", LogCollectorUtils.getFolderPath(this.rootFolderPath, folderPath));
            this.createLogDirOnPath(clusterWideFolderPath);
            if (logPerFile) {
                this.collectClusterWideResourcesPerFile(clusterWideFolderPath, (String)resourceType);
            } else {
                String yaml = this.executeCollectionCall(String.format("collect descriptions of type: %s", resourceType), () -> this.kubeCmdClient.getResourcesAsYaml(resourceType));
                String resFileName = LogCollectorUtils.getYamlFileNameForResource(resourceType);
                String filePath = LogCollectorUtils.getFullPathForFolderPathAndFileName(clusterWideFolderPath, resFileName);
                this.writeDataToFile(filePath, yaml);
            }
        });
    }

    public void collectLogsFromPodsInNamespace(String namespaceName, String namespaceFolderPath) {
        LOGGER.info("Collecting logs from all Pods in Namespace: {}", (Object)namespaceName);
        List pods = this.executeCollectionCall(String.format("list Pods in Namespace: %s", namespaceName), () -> this.kubeClient.listPods(namespaceName));
        if (pods != null && !pods.isEmpty()) {
            String podsFolderPath = this.createResourceDirectoryInNamespaceDir(namespaceFolderPath, "pod");
            pods.forEach(pod -> {
                String podName = pod.getMetadata().getName();
                List<String> containers = pod.getSpec().getContainers().stream().map(Container::getName).toList();
                List<String> initContainers = pod.getSpec().getInitContainers().stream().map(Container::getName).toList();
                this.collectPodDescription(namespaceName, podsFolderPath, podName);
                this.collectLogsFromPodContainers(namespaceName, podsFolderPath, podName, containers);
                this.collectLogsFromPodContainers(namespaceName, podsFolderPath, podName, initContainers);
            });
        }
    }

    private void collectLogsFromPodContainers(String namespaceName, String podsFolderPath, String podName, List<String> containerNames) {
        containerNames.forEach(containerName -> this.collectLogsFromPodContainer(namespaceName, podsFolderPath, podName, (String)containerName));
    }

    private void collectLogsFromPodContainer(String namespaceName, String podsFolderPath, String podName, String containerName) {
        String containerLog = this.executeCollectionCall(String.format("collect logs from Pod:%s", podName), () -> this.kubeCmdClient.inNamespace(namespaceName).logs(podName, containerName));
        String podConLogFileName = LogCollectorUtils.getLogFileNameForPodContainer(podName, containerName);
        String filePath = LogCollectorUtils.getFullPathForFolderPathAndFileName(podsFolderPath, podConLogFileName);
        this.writeDataToFile(filePath, containerLog);
    }

    private void collectPodDescription(String namespaceName, String podsFolderPath, String podName) {
        String podDesc = this.executeCollectionCall(String.format("collect description of Pod:%s", podName), () -> this.kubeCmdClient.inNamespace(namespaceName).describe("pod", podName));
        String podDescFileName = LogCollectorUtils.getLogFileNameForPodDescription(podName);
        String filePath = LogCollectorUtils.getFullPathForFolderPathAndFileName(podsFolderPath, podDescFileName);
        this.writeDataToFile(filePath, podDesc);
    }

    private void collectClusterWideResourcesPerFile(String clusterWideFolderPath, String resourceType) {
        List resources = this.kubeCmdClient.list(resourceType);
        if (resources != null && !resources.isEmpty()) {
            String fullFolderPath = this.createResourceDirectoryInNamespaceDir(clusterWideFolderPath, resourceType);
            resources.forEach(resourceName -> {
                String yaml = this.executeCollectionCall(String.format("collect YAML description for %s:%s", resourceType, resourceName), () -> this.kubeCmdClient.getResourceAsYaml(resourceType, resourceName));
                String resFileName = LogCollectorUtils.getYamlFileNameForResource(resourceName);
                String fileName = LogCollectorUtils.getFullPathForFolderPathAndFileName(fullFolderPath, resFileName);
                this.writeDataToFile(fileName, yaml);
            });
        }
    }

    public void collectEventsFromNamespace(String namespaceName, String namespaceFolderPath) {
        LOGGER.info("Collecting events from Namespace: {}", (Object)namespaceName);
        String events = this.executeCollectionCall(String.format("collect %s from %s", "events", namespaceName), () -> this.kubeCmdClient.inNamespace(namespaceName).getEvents());
        String eventsFileName = LogCollectorUtils.getLogFileNameForResource("events");
        String fileName = LogCollectorUtils.getFullPathForFolderPathAndFileName(namespaceFolderPath, eventsFileName);
        this.writeDataToFile(fileName, events);
    }

    private void collectResourcesDescInNamespace(String namespaceName, String namespaceFolderPath) {
        this.namespacedResources.forEach(resource -> this.collectDescriptionOfResourceInNamespace(namespaceName, namespaceFolderPath, (String)resource));
    }

    private void collectDescriptionOfResourceInNamespace(String namespaceName, String namespaceFolderPath, String resourceType) {
        LOGGER.info("Collecting YAMLs of {} from Namespace: {}", (Object)resourceType, (Object)namespaceName);
        List resources = this.executeCollectionCall(String.format("list resources of type: %s in Namespace: %s", resourceType, namespaceName), () -> this.kubeCmdClient.inNamespace(namespaceName).list(resourceType));
        if (resources != null && !resources.isEmpty()) {
            String fullFolderPath = this.createResourceDirectoryInNamespaceDir(namespaceFolderPath, resourceType);
            resources.forEach(resourceName -> {
                String yaml = this.executeCollectionCall(String.format("collect YAML description for %s:%s", resourceType, resourceName), () -> this.kubeCmdClient.inNamespace(namespaceName).getResourceAsYaml(resourceType, resourceName));
                String resFileName = LogCollectorUtils.getYamlFileNameForResource(resourceName);
                String fileName = LogCollectorUtils.getFullPathForFolderPathAndFileName(fullFolderPath, resFileName);
                this.writeDataToFile(fileName, yaml);
            });
        }
    }

    private String createNamespaceDirectory(String namespaceName, String folderPath) {
        return this.createLogDirOnPath(LogCollectorUtils.getFullDirPathWithNamespace(folderPath, namespaceName));
    }

    private String createResourceDirectoryInNamespaceDir(String namespaceFolderPath, String resourceType) {
        return this.createLogDirOnPath(LogCollectorUtils.getNamespaceFullDirPathForResourceType(namespaceFolderPath, resourceType));
    }

    private String createLogDirOnPath(String fullPathToDirectory) {
        File logDir = Paths.get(fullPathToDirectory, new String[0]).toFile();
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new RuntimeException(String.format("Failed to create root log directories on path: %s", logDir.getAbsolutePath()));
        }
        return logDir.getAbsolutePath();
    }

    private void writeDataToFile(String fullFilePath, String data) {
        if (data != null && !data.isEmpty()) {
            try {
                Files.writeString(Paths.get(fullFilePath, new String[0]), (CharSequence)data, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to write to the %s file due to: %s", fullFilePath, e.getMessage()));
            }
        }
    }

    private <T> T executeCollectionCall(String errorOperationMessage, Supplier<T> executeCall) {
        try {
            return executeCall.get();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to {}, due to: {}", (Object)errorOperationMessage, (Object)e.getMessage());
            return null;
        }
    }
}

