/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe;

import io.skodjob.testframe.LogCollector;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LogCollectorBuilder {
    private String rootFolderPath;
    private List<String> namespacedResources;
    private List<String> clusterWideResources;
    private KubeClient kubeClient;
    private KubeCmdClient<?> kubeCmdClient;

    public LogCollectorBuilder(LogCollector logCollector) {
        this.rootFolderPath = logCollector.rootFolderPath;
        this.namespacedResources = logCollector.namespacedResources;
        this.clusterWideResources = logCollector.clusterWideResources;
    }

    public LogCollectorBuilder() {
    }

    public LogCollectorBuilder withRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
        return this;
    }

    public LogCollectorBuilder withNamespacedResources(String ... resources) {
        this.namespacedResources = Arrays.stream(resources).toList().stream().filter(resource -> !resource.equals("pod") && !resource.equals("pods")).collect(Collectors.toList());
        return this;
    }

    public LogCollectorBuilder withClusterWideResources(String ... resources) {
        this.clusterWideResources = new ArrayList<String>(Arrays.stream(resources).toList());
        return this;
    }

    public LogCollectorBuilder withKubeClient(KubeClient kubeClient) {
        this.kubeClient = kubeClient;
        return this;
    }

    public LogCollectorBuilder withKubeCmdClient(KubeCmdClient<?> kubeCmdClient) {
        this.kubeCmdClient = kubeCmdClient;
        return this;
    }

    public String getRootFolderPath() {
        return this.rootFolderPath;
    }

    public List<String> getNamespacedResources() {
        return this.namespacedResources;
    }

    public List<String> getClusterWideResources() {
        return this.clusterWideResources;
    }

    public KubeClient getKubeClient() {
        return this.kubeClient;
    }

    public KubeCmdClient<?> getKubeCmdClient() {
        return this.kubeCmdClient;
    }

    public LogCollector build() {
        return new LogCollector(this);
    }
}

