/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.listeners;

import io.skodjob.testframe.annotations.MustGather;
import io.skodjob.testframe.interfaces.MustGatherSupplier;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExceptionCallbackListener
implements TestExecutionExceptionHandler,
LifecycleMethodExecutionExceptionHandler {
    static final Logger LOGGER = LoggerFactory.getLogger(TestExceptionCallbackListener.class);

    private TestExceptionCallbackListener() {
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.error("Test failed at {} : {}", new Object[]{"Test execution", throwable.getMessage(), throwable});
        this.saveKubernetesState(context, throwable);
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.error("Test failed at {} : {}", new Object[]{"Test before all", throwable.getMessage(), throwable});
        this.saveKubernetesState(context, throwable);
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.error("Test failed at {} : {}", new Object[]{"Test before each", throwable.getMessage(), throwable});
        this.saveKubernetesState(context, throwable);
    }

    public void handleAfterEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.error("Test failed at {} : {}", new Object[]{"Test after each", throwable.getMessage(), throwable});
        this.saveKubernetesState(context, throwable);
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.error("Test failed at {} : {}", new Object[]{"Test after all", throwable.getMessage(), throwable});
        this.saveKubernetesState(context, throwable);
    }

    private void saveKubernetesState(ExtensionContext context, Throwable throwable) throws Throwable {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), MustGather.class);
        if (annotation.isPresent() && ((MustGather)annotation.get()).config() != null) {
            Class<? extends MustGatherSupplier> supplierClass = ((MustGather)annotation.get()).config();
            MustGatherSupplier supplierInstance = supplierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            supplierInstance.saveKubernetesState(context);
        }
        throw throwable;
    }
}

