/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.skodjob.testframe.MetricsComponent;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.exceptions.IncompleteMetricsException;
import io.skodjob.testframe.exceptions.MetricsCollectionException;
import io.skodjob.testframe.exceptions.NoPodsFoundException;
import io.skodjob.testframe.executor.Exec;
import io.skodjob.testframe.metrics.Metric;
import io.skodjob.testframe.metrics.PrometheusTextFormatParser;
import io.skodjob.testframe.resources.KubeResourceManager;
import io.skodjob.testframe.wait.Wait;
import io.skodjob.testframe.wait.WaitException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsCollector.class);
    private static final long EXEC_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(20L).toMillis();
    protected String namespaceName;
    protected String scraperPodName;
    protected String scraperPodImage;
    protected boolean deployScraperPod;
    protected MetricsComponent component;
    protected Map<String, List<Metric>> collectedData;
    private Exec exec;
    private KubernetesClient kubeClient;
    private KubeCmdClient<?> kubeCmdClient;

    protected synchronized void setKubeClient(KubernetesClient client) {
        this.kubeClient = client;
    }

    protected synchronized void setKubeCmdClient(KubeCmdClient<?> client) {
        this.kubeCmdClient = client;
    }

    protected void setExec(Exec exec) {
        this.exec = exec;
    }

    synchronized KubernetesClient getKubeClient() {
        if (this.kubeClient == null) {
            this.kubeClient = KubeResourceManager.get().kubeClient().getClient();
            if (this.kubeClient == null) {
                throw new IllegalStateException("KubeClient is not available");
            }
        }
        return this.kubeClient;
    }

    synchronized <K extends KubeCmdClient<K>> K getKubeCmdClient() {
        if (this.kubeCmdClient == null) {
            this.kubeCmdClient = KubeResourceManager.get().kubeCmdClient();
            if (this.kubeCmdClient == null) {
                throw new IllegalStateException("KubeCmdClient is not available");
            }
        }
        return (K)this.kubeCmdClient;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScraperPodName() {
        return this.scraperPodName;
    }

    public String getScraperPodImage() {
        return this.scraperPodImage;
    }

    public MetricsComponent getComponent() {
        return this.component;
    }

    public boolean getDeployScraperPod() {
        return this.deployScraperPod;
    }

    public Map<String, List<Metric>> getCollectedData() {
        return this.collectedData;
    }

    protected Exec getExec() {
        return this.exec;
    }

    protected void setCollectedData(Map<String, List<Metric>> collectedData) {
        this.collectedData = collectedData;
    }

    protected Builder newBuilder() {
        return new Builder();
    }

    protected Builder updateBuilder(Builder builder) {
        Builder b = builder.withNamespaceName(this.getNamespaceName()).withComponent(this.getComponent()).withScraperPodImage(this.getScraperPodImage()).withScraperPodName(this.getScraperPodName()).withCollectedData(this.getCollectedData()).withExec(this.getExec());
        if (this.getDeployScraperPod()) {
            b.withDeployScraperPod();
        }
        return b;
    }

    public Builder toBuilder() {
        return this.updateBuilder(this.newBuilder());
    }

    protected MetricsCollector(Builder builder) {
        if (builder.namespaceName == null || builder.namespaceName.isEmpty()) {
            throw new InvalidParameterException("Namespace name is not set");
        }
        if (builder.scraperPodName == null || builder.scraperPodName.isEmpty()) {
            throw new InvalidParameterException("Scraper Pod name is not set");
        }
        if (builder.component == null) {
            throw new InvalidParameterException("Component is not set");
        }
        if (builder.collectedData == null) {
            builder.collectedData = Collections.emptyMap();
        }
        if (builder.exec == null) {
            builder.exec = new Exec();
        }
        this.namespaceName = builder.namespaceName;
        this.scraperPodName = builder.scraperPodName;
        this.scraperPodImage = builder.scraperPodImage;
        this.deployScraperPod = builder.deployScraperPod;
        this.component = builder.component;
        this.collectedData = builder.collectedData;
        this.exec = builder.exec;
    }

    protected String collectMetrics(String metricsPodIp, String podName) throws InterruptedException, ExecutionException, IOException {
        if (this.deployScraperPod) {
            this.deployScraperPod();
        }
        List<String> executableCommand = Arrays.asList(this.getKubeCmdClient().inNamespace(this.namespaceName).toString(), "exec", this.scraperPodName, "-n", this.namespaceName, "--", "curl", metricsPodIp + ":" + this.component.getDefaultMetricsPort() + this.component.getDefaultMetricsPath());
        LOGGER.debug("Executing command:{} for scrape the metrics", executableCommand);
        int ret = this.exec.execute(null, executableCommand, null, EXEC_TIMEOUT_MS_DEFAULT);
        LOGGER.debug("Metrics collection for Pod: {}/{}({}) from Pod: {}/{} finished with return code: {}", new Object[]{this.namespaceName, podName, metricsPodIp, this.namespaceName, this.scraperPodName, ret});
        if (this.deployScraperPod) {
            this.deleteScraperPod();
        }
        return this.exec.out();
    }

    private void deployScraperPod() {
        Pod scraperPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.scraperPodName)).withNamespace(this.namespaceName)).addToLabels(Map.of("io.skodjob.scraper-pod", "true"))).endMetadata()).withNewSpec().withRestartPolicy("Never")).addNewContainer().withName("scraper-container")).withImage(this.scraperPodImage)).withCommand(new String[]{"/bin/sh"})).withArgs(new String[]{"-c", "while true; do sleep 3600; done"})).endContainer()).endSpec()).build();
        KubeResourceManager.get().createResourceWithWait((HasMetadata[])new Pod[]{scraperPod});
    }

    private void deleteScraperPod() {
        KubeResourceManager.get().deleteResourceWithWait((HasMetadata[])new Pod[]{((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.scraperPodName)).withNamespace(this.namespaceName)).endMetadata()).build()});
    }

    public final List<Metric> collectMetricWithLabels(String podName, String label) {
        return this.collectedData.getOrDefault(podName, Collections.emptyList()).stream().filter(metric -> metric.getLabels().containsKey(label)).toList();
    }

    public final void collectMetricsFromPods(long timeoutDuration) {
        MetricsCollectionStatus status = new MetricsCollectionStatus();
        try {
            Wait.until((String)"metrics won't be empty", (long)TestFrameConstants.GLOBAL_POLL_INTERVAL_1_SEC, (long)timeoutDuration, () -> {
                try {
                    Map<String, List<Metric>> metricsData = this.collectMetricsFromPodsWithoutWait();
                    if (metricsData.isEmpty()) {
                        status.setMessage("No pods found or no metrics available from pods.");
                        status.setType(MetricsCollectionStatus.Type.NO_DATA);
                        LOGGER.warn("Metrics collection failed: {}", (Object)status.getMessage());
                        return false;
                    }
                    if (metricsData.values().stream().anyMatch(List::isEmpty)) {
                        status.setMessage("Incomplete metrics data collected.");
                        status.setType(MetricsCollectionStatus.Type.INCOMPLETE_DATA);
                        LOGGER.warn("Metrics collection incomplete: Some pods returned empty metrics.");
                        return false;
                    }
                    this.collectedData = metricsData;
                    return true;
                }
                catch (Exception e) {
                    status.setMessage(e.getMessage());
                    status.setType(MetricsCollectionStatus.Type.ERROR);
                    status.setException(e);
                    LOGGER.warn("Error during metrics collection: {}", (Object)status.getMessage(), (Object)e);
                    return false;
                }
            }, () -> LOGGER.error("Failed to collect metrics within the allowed time: {}", (Object)status.getMessage()));
        }
        catch (WaitException we) {
            LOGGER.error("Metrics collection terminated due to timeout: {}", (Object)we.getMessage());
            throw this.determineExceptionFromStatus(status);
        }
    }

    MetricsCollectionException determineExceptionFromStatus(MetricsCollectionStatus status) {
        MetricsCollectionStatus.Type type = status.getType();
        if (type == null) {
            return new MetricsCollectionException("Unknown error occurred during metrics collection");
        }
        return switch (status.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case MetricsCollectionStatus.Type.NO_DATA -> new NoPodsFoundException(status.getMessage());
            case MetricsCollectionStatus.Type.INCOMPLETE_DATA -> new IncompleteMetricsException(status.getMessage());
            case MetricsCollectionStatus.Type.ERROR -> new MetricsCollectionException(status.getMessage(), status.getException());
        };
    }

    public final void collectMetricsFromPods() throws MetricsCollectionException {
        this.collectMetricsFromPods(TestFrameConstants.GLOBAL_TIMEOUT_MEDIUM);
    }

    public final Map<String, List<Metric>> collectMetricsFromPodsWithoutWait() {
        HashMap<String, List<Metric>> map = new HashMap<String, List<Metric>>();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubeClient().pods().inNamespace(this.namespaceName)).withLabelSelector(this.component.getLabelSelector())).list()).getItems();
        if (pods.isEmpty()) {
            LOGGER.info("No pods found with the specified label selector.");
            return map;
        }
        for (Pod p : pods) {
            String podName = p.getMetadata().getName();
            Object podIP = p.getStatus().getPodIP();
            if (TestFrameEnv.IP_FAMILY.equals("ipv6")) {
                podIP = "[" + (String)podIP + "]";
            }
            try {
                String metrics = this.collectMetrics((String)podIP, podName);
                List<Metric> parsedMetrics = PrometheusTextFormatParser.parse(metrics);
                map.put(podName, parsedMetrics);
                LOGGER.info("Finished metrics collection from {}", (Object)podName);
                LOGGER.debug("Collected metrics from {}: {}", (Object)podName, (Object)metrics);
                LOGGER.debug("Parsed metrics from {}:\n{}", (Object)podName, parsedMetrics);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LOGGER.error("Failed to collect metrics from {}: {}", (Object)podName, (Object)e.getMessage());
                errorMap.put(podName, e.getMessage());
            }
        }
        if (!errorMap.isEmpty()) {
            throw new MetricsCollectionException("Errors occurred while collecting metrics: " + String.valueOf(errorMap));
        }
        return map;
    }

    public static class Builder {
        private String namespaceName;
        private String scraperPodName;
        private String scraperPodImage = "quay.io/curl/curl:latest";
        private boolean deployScraperPod;
        private MetricsComponent component;
        private Map<String, List<Metric>> collectedData;
        private Exec exec;

        public Builder withNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder withScraperPodName(String scraperPodName) {
            this.scraperPodName = scraperPodName;
            return this;
        }

        public Builder withScraperPodImage(String image) {
            this.scraperPodImage = image;
            return this;
        }

        public Builder withDeployScraperPod() {
            this.deployScraperPod = true;
            return this;
        }

        public Builder withComponent(MetricsComponent component) {
            this.component = component;
            return this;
        }

        protected Builder withCollectedData(Map<String, List<Metric>> collectedData) {
            this.collectedData = collectedData;
            return this;
        }

        protected Builder withExec(Exec exec) {
            this.exec = exec;
            return this;
        }

        public MetricsCollector build() {
            return new MetricsCollector(this);
        }
    }

    static class MetricsCollectionStatus {
        private String message;
        private Exception exception;
        private Type type;

        MetricsCollectionStatus() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        static enum Type {
            NO_DATA,
            INCOMPLETE_DATA,
            ERROR;

        }
    }
}

