/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.metrics;

import io.skodjob.testframe.metrics.Counter;
import io.skodjob.testframe.metrics.Gauge;
import io.skodjob.testframe.metrics.Histogram;
import io.skodjob.testframe.metrics.Metric;
import io.skodjob.testframe.metrics.Summary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrometheusTextFormatParser {
    private PrometheusTextFormatParser() {
    }

    public static List<Metric> parse(String data) throws IOException {
        String line;
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        BufferedReader reader = new BufferedReader(new StringReader(data));
        String type = "";
        Histogram currentHistogram = null;
        Summary currentSummary = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) {
                if (!line.contains("TYPE")) continue;
                String[] parts = line.split(" ");
                type = parts[3];
                continue;
            }
            int lastSpace = line.lastIndexOf(32);
            if (lastSpace == -1) continue;
            String metricNameAndLabels = line.substring(0, lastSpace);
            String valueStr = line.substring(lastSpace + 1).trim();
            double value = Double.parseDouble(valueStr);
            String[] nameAndLabels = PrometheusTextFormatParser.parseNameAndLabels(metricNameAndLabels);
            String name = nameAndLabels[0];
            Map<String, String> labels = PrometheusTextFormatParser.parseLabels(nameAndLabels[1]);
            Map<String, String> customLabels = PrometheusTextFormatParser.getCustomLabels(labels);
            if (name.endsWith("_total")) {
                metrics.add(new Counter(name, customLabels, line, value));
                continue;
            }
            if (name.contains("_bucket")) {
                if (currentHistogram == null || !currentHistogram.name.equals(name) || !currentHistogram.labels.equals(customLabels)) {
                    currentHistogram = new Histogram(name, customLabels, line);
                    metrics.add(currentHistogram);
                }
                double upperBound = labels.get("le").contains("+Inf") ? Double.MAX_VALUE : Double.parseDouble(labels.get("le"));
                currentHistogram.addBucket(upperBound, value);
                continue;
            }
            if (name.endsWith("_sum")) {
                String baseName = name.substring(0, name.length() - 4);
                if (currentHistogram != null && currentHistogram.name.equals(baseName + "_bucket") && currentHistogram.labels.equals(customLabels)) {
                    currentHistogram.setSum(value);
                } else if (currentSummary != null && currentSummary.name.equals(baseName) && currentSummary.labels.equals(customLabels)) {
                    currentSummary.setSum(value);
                }
                metrics.add(new Gauge(name, customLabels, line, value));
                continue;
            }
            if (name.endsWith("_count")) {
                String baseName = name.substring(0, name.length() - 6);
                if (currentHistogram != null && currentHistogram.name.equals(baseName + "_bucket") && currentHistogram.labels.equals(customLabels)) {
                    currentHistogram.setCount((int)value);
                    continue;
                }
                if (currentSummary != null && currentSummary.name.equals(baseName) && currentSummary.labels.equals(customLabels)) {
                    currentSummary.setCount((int)value);
                    continue;
                }
                if (type == null) continue;
                if (type.equals("gauge")) {
                    metrics.add(new Gauge(name, customLabels, line, value));
                    continue;
                }
                if (!type.equals("counter")) continue;
                metrics.add(new Counter(name, customLabels, line, value));
                continue;
            }
            if (labels.containsKey("quantile")) {
                if (currentSummary == null || !currentSummary.name.equals(name) || !currentSummary.labels.equals(customLabels)) {
                    currentSummary = new Summary(name, customLabels, line);
                    metrics.add(currentSummary);
                }
                double quantile = Double.parseDouble(labels.get("quantile"));
                currentSummary.addQuantile(quantile, value);
                continue;
            }
            metrics.add(new Gauge(name, labels, line, value));
        }
        return metrics;
    }

    private static Map<String, String> getCustomLabels(Map<String, String> labels) {
        HashMap<String, String> customLabels = new HashMap<String, String>(labels);
        customLabels.remove("le");
        customLabels.remove("quantile");
        return customLabels;
    }

    private static String[] parseNameAndLabels(String metricNameAndLabels) {
        int labelStartIndex = metricNameAndLabels.indexOf(123);
        if (labelStartIndex == -1) {
            return new String[]{metricNameAndLabels, ""};
        }
        String name = metricNameAndLabels.substring(0, labelStartIndex);
        String labels = metricNameAndLabels.substring(labelStartIndex);
        return new String[]{name, labels};
    }

    private static Map<String, String> parseLabels(String labelString) {
        String[] labelPairs;
        HashMap<String, String> labels = new HashMap<String, String>();
        if (labelString.isEmpty()) {
            return labels;
        }
        labelString = labelString.substring(1, labelString.length() - 1);
        for (String labelPair : labelPairs = labelString.split(",")) {
            String[] keyValue;
            if ((labelPair = labelPair.trim()).isEmpty() || (keyValue = labelPair.split("=", 2)).length < 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].replaceAll("^\"|\"$", "").trim();
            labels.put(key, value);
        }
        return labels;
    }
}

