/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanList;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class InstallPlanType
implements ResourceType<InstallPlan> {
    private final MixedOperation<InstallPlan, InstallPlanList, Resource<InstallPlan>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().installPlans();

    public String getKind() {
        return "InstallPlan";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(InstallPlan resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(InstallPlan resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(InstallPlan resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(InstallPlan resource, Consumer<InstallPlan> editor) {
        InstallPlan toBeReplaced = (InstallPlan)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(InstallPlan resource) {
        return resource != null;
    }

    public boolean isDeleted(InstallPlan resource) {
        return resource == null;
    }
}

