/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionList;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class SubscriptionType
implements ResourceType<Subscription> {
    private final MixedOperation<Subscription, SubscriptionList, Resource<Subscription>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().subscriptions();

    public String getKind() {
        return "Subscription";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Subscription resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(Subscription resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(Subscription resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(Subscription resource, Consumer<Subscription> editor) {
        Subscription toBeReplaced = (Subscription)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(Subscription resource) {
        return resource != null;
    }

    public boolean isDeleted(Subscription resource) {
        return resource == null;
    }
}

