/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.olm;

import io.skodjob.testframe.executor.Exec;
import io.skodjob.testframe.executor.ExecResult;
import io.skodjob.testframe.olm.OperatorSdkRunBuilder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;

public class OperatorSdkRun {
    protected String namespace;
    protected String timeout;
    protected String installMode;
    protected String indexImage;
    protected String kubeconfig;
    protected String bundleImage;
    protected boolean skipTlsVerify;
    private static final String OPTION_INDEX_IMAGE = "--index-image";
    private static final String OPTION_NAMESPACE = "--namespace";
    private static final String OPTION_KUBECONFIG = "--kubeconfig";
    private static final String OPTION_TIMEOUT = "--timeout";
    private static final String OPTION_INSTALL_MODE = "--install-mode";
    private static final String OPTION_SKIP_TLS_VERIFY = "--skip-tls-verify";
    private static final String CMD = "operator-sdk";
    private static final String RUN = "run";
    private static final String BUNDLE = "bundle";

    public OperatorSdkRun(OperatorSdkRunBuilder operatorSdkRunBuilder) {
        if (operatorSdkRunBuilder.getNamespace() == null) {
            throw new InvalidParameterException("Namespace is a mandatory parameter for OperatorSdkRun!");
        }
        if (operatorSdkRunBuilder.getBundleImage() == null) {
            throw new InvalidParameterException("BundleImage is a mandatory parameter for OperatorSdkRun!");
        }
        if (operatorSdkRunBuilder.getInstallMode() == null) {
            throw new InvalidParameterException("InstallMode is a mandatory parameter for OperatorSdkRun!");
        }
        this.namespace = operatorSdkRunBuilder.getNamespace();
        this.bundleImage = operatorSdkRunBuilder.getBundleImage();
        this.installMode = operatorSdkRunBuilder.getInstallMode();
        this.timeout = operatorSdkRunBuilder.getTimeout();
        this.indexImage = operatorSdkRunBuilder.getIndexImage();
        this.kubeconfig = operatorSdkRunBuilder.getKubeconfig();
        this.skipTlsVerify = operatorSdkRunBuilder.getSkipTlsVerify();
    }

    public ExecResult run() {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(CMD, RUN, BUNDLE, this.bundleImage));
        command.add(OPTION_NAMESPACE);
        command.add(this.namespace);
        command.add(OPTION_INSTALL_MODE);
        command.add(this.installMode);
        if (this.indexImage != null) {
            command.add(OPTION_INDEX_IMAGE);
            command.add(this.indexImage);
        }
        if (this.timeout != null) {
            command.add(OPTION_TIMEOUT);
            command.add(this.timeout);
        }
        if (this.kubeconfig != null) {
            command.add(OPTION_KUBECONFIG);
            command.add(this.kubeconfig);
        }
        if (this.skipTlsVerify) {
            command.add(OPTION_SKIP_TLS_VERIFY);
        }
        return Exec.exec(command);
    }
}

