/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class BuildConfigType
implements ResourceType<BuildConfig> {
    private final MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().buildConfigs();

    public NonNamespaceOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public String getKind() {
        return "BuildConfig";
    }

    public void create(BuildConfig resource) {
        ((BuildConfigResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(BuildConfig resource) {
        ((BuildConfigResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(BuildConfig resource) {
        ((BuildConfigResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).delete();
    }

    public void replace(BuildConfig resource, Consumer<BuildConfig> editor) {
        BuildConfig toBeReplaced = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(BuildConfig resource) {
        return ((BuildConfigResource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).isReady();
    }

    public boolean isDeleted(BuildConfig resource) {
        return resource == null;
    }
}

