/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceList;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class CatalogSourceType
implements ResourceType<CatalogSource> {
    private final MixedOperation<CatalogSource, CatalogSourceList, Resource<CatalogSource>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().catalogSources();

    public String getKind() {
        return "CatalogSource";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(CatalogSource resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(CatalogSource resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(CatalogSource resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(CatalogSource resource, Consumer<CatalogSource> editor) {
        CatalogSource toBeReplaced = (CatalogSource)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(CatalogSource resource) {
        return resource != null;
    }

    public boolean isDeleted(CatalogSource resource) {
        return resource == null;
    }
}

