/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ImageStreamType
implements ResourceType<ImageStream> {
    private final MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().imageStreams();

    public NonNamespaceOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public String getKind() {
        return "ImageStream";
    }

    public void create(ImageStream resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(ImageStream resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(ImageStream resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).delete();
    }

    public void replace(ImageStream resource, Consumer<ImageStream> editor) {
        ImageStream toBeReplaced = (ImageStream)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(ImageStream resource) {
        return ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).isReady();
    }

    public boolean isDeleted(ImageStream resource) {
        return resource == null;
    }
}

