/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupList;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class OperatorGroupType
implements ResourceType<OperatorGroup> {
    private final MixedOperation<OperatorGroup, OperatorGroupList, Resource<OperatorGroup>> client = KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().operatorGroups();

    public String getKind() {
        return "OperatorGroup";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(OperatorGroup resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(OperatorGroup resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(OperatorGroup resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(OperatorGroup resource, Consumer<OperatorGroup> editor) {
        OperatorGroup toBeReplaced = (OperatorGroup)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean isReady(OperatorGroup resource) {
        return resource != null;
    }

    public boolean isDeleted(OperatorGroup resource) {
        return resource == null;
    }
}

