/*
 * Decompiled with CFR 0.152.
 */
package skuber.pekkoclient.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.settings.ConnectionPoolSettingsImpl;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import skuber.api.client.Context;
import skuber.api.client.LoggingConfig;
import skuber.api.security.TLS$;
import skuber.pekkoclient.impl.PekkoKubernetesClientImpl;

public final class PekkoKubernetesClientImpl$ {
    public static final PekkoKubernetesClientImpl$ MODULE$ = new PekkoKubernetesClientImpl$();

    public PekkoKubernetesClientImpl apply(Context k8sContext, LoggingConfig logConfig, Option<Function0<BoxedUnit>> closeHook, Config appConfig, ActorSystem actorSystem) {
        String string;
        Option sslContext;
        Duration watchPoolIdleTimeout;
        Duration watchContinuouslyIdleTimeout;
        Duration watchContinuouslyRequestTimeout;
        Duration podLogIdleTimeout;
        Duration watchIdleTimeout;
        ExecutionContext dispatcher;
        block4: {
            appConfig.checkValid(ConfigFactory.defaultReference(), new String[]{"skuber"});
            dispatcher = (ExecutionContext)PekkoKubernetesClientImpl$.getSkuberConfig$1("pekko.dispatcher", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.dispatcherFromConfig$1(configKey, appConfig, actorSystem), actorSystem.dispatcher(), appConfig);
            watchIdleTimeout = (Duration)PekkoKubernetesClientImpl$.getSkuberConfig$1("watch.idle-timeout", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), Duration$.MODULE$.Inf(), appConfig);
            podLogIdleTimeout = (Duration)PekkoKubernetesClientImpl$.getSkuberConfig$1("pod-log.idle-timeout", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), Duration$.MODULE$.Inf(), appConfig);
            watchContinuouslyRequestTimeout = (Duration)PekkoKubernetesClientImpl$.getSkuberConfig$1("watch-continuously.request-timeout", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds(), appConfig);
            watchContinuouslyIdleTimeout = (Duration)PekkoKubernetesClientImpl$.getSkuberConfig$1("watch-continuously.idle-timeout", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds(), appConfig);
            watchPoolIdleTimeout = (Duration)PekkoKubernetesClientImpl$.getSkuberConfig$1("watch-continuously.pool-idle-timeout", (Function1 & Serializable)configKey -> PekkoKubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds(), appConfig);
            Predef$.MODULE$.require(watchContinuouslyIdleTimeout.$greater((Object)watchContinuouslyRequestTimeout));
            if (logConfig.logConfiguration()) {
                LoggingAdapter log = Logging$.MODULE$.getLogger(actorSystem, (Object)"skuber.api");
                log.info("Using following context for connecting to Kubernetes cluster: {}", (Object)k8sContext);
            }
            sslContext = TLS$.MODULE$.establishSSLContext(k8sContext);
            String string2 = k8sContext.namespace().name();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = "default";
                    break block4;
                }
            }
            string = string2;
        }
        String theNamespaceName = string;
        Function2 & Serializable requestMaker = (Function2 & Serializable)(uri, method) -> HttpRequest$.MODULE$.apply(method, uri, HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        ConnectionPoolSettingsImpl defaultClientSettings = ConnectionPoolSettings$.MODULE$.apply(actorSystem.settings().config());
        ClientConnectionSettings watchConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(watchIdleTimeout);
        ConnectionPoolSettings watchSettings = defaultClientSettings.withConnectionSettings(watchConnectionSettings);
        ClientConnectionSettings podLogConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(podLogIdleTimeout);
        ConnectionPoolSettings podLogSettings = defaultClientSettings.withConnectionSettings(podLogConnectionSettings);
        return new PekkoKubernetesClientImpl((Function2<Uri, HttpMethod, HttpRequest>)requestMaker, k8sContext.cluster().server(), k8sContext.authInfo(), theNamespaceName, watchContinuouslyRequestTimeout, watchContinuouslyIdleTimeout, watchPoolIdleTimeout, watchSettings, podLogSettings, (Option<SSLContext>)sslContext, logConfig, closeHook, actorSystem, dispatcher);
    }

    private static final Object getSkuberConfig$1(String key, Function1 fromConfig, Object object, Config appConfig$1) {
        String skuberConfigKey = new StringBuilder(7).append("skuber.").append(key).toString();
        if (appConfig$1.getIsNull(skuberConfigKey)) {
            return object;
        }
        Option option = (Option)fromConfig.apply((Object)skuberConfigKey);
        if (None$.MODULE$.equals(option)) {
            return object;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object t = some.value();
            return t;
        }
        throw new MatchError((Object)option);
    }

    private static final Option dispatcherFromConfig$1(String configKey, Config appConfig$1, ActorSystem actorSystem$1) {
        if (appConfig$1.getString(configKey).isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)actorSystem$1.dispatchers().lookup(appConfig$1.getString(configKey)));
    }

    private static final Option durationFomConfig$1(String configKey, Config appConfig$1) {
        return new Some((Object)Duration$.MODULE$.fromNanos(appConfig$1.getDuration(configKey).toNanos()));
    }

    private PekkoKubernetesClientImpl$() {
    }
}

