/*
 * Decompiled with CFR 0.152.
 */
package skuber.api.client.impl;

import akka.actor.ActorSystem;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.impl.settings.ConnectionPoolSettingsImpl;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.http.scaladsl.settings.ConnectionPoolSettings$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import skuber.api.client.Context;
import skuber.api.client.LoggingConfig;
import skuber.api.client.impl.KubernetesClientImpl;
import skuber.api.security.TLS$;

public final class KubernetesClientImpl$ {
    public static KubernetesClientImpl$ MODULE$;

    static {
        new KubernetesClientImpl$();
    }

    public KubernetesClientImpl apply(Context k8sContext, LoggingConfig logConfig, Option<Function0<BoxedUnit>> closeHook, Config appConfig, ActorSystem actorSystem) {
        appConfig.checkValid(ConfigFactory.defaultReference(), new String[]{"skuber"});
        ExecutionContext dispatcher = (ExecutionContext)KubernetesClientImpl$.getSkuberConfig$1("akka.dispatcher", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.dispatcherFromConfig$1(configKey, appConfig, actorSystem), actorSystem.dispatcher(), appConfig);
        Duration watchIdleTimeout = (Duration)KubernetesClientImpl$.getSkuberConfig$1("watch.idle-timeout", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), Duration$.MODULE$.Inf(), appConfig);
        Duration podLogIdleTimeout = (Duration)KubernetesClientImpl$.getSkuberConfig$1("pod-log.idle-timeout", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), Duration$.MODULE$.Inf(), appConfig);
        Duration watchContinuouslyRequestTimeout = (Duration)KubernetesClientImpl$.getSkuberConfig$1("watch-continuously.request-timeout", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds(), appConfig);
        Duration watchContinuouslyIdleTimeout = (Duration)KubernetesClientImpl$.getSkuberConfig$1("watch-continuously.idle-timeout", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds(), appConfig);
        Duration watchPoolIdleTimeout = (Duration)KubernetesClientImpl$.getSkuberConfig$1("watch-continuously.pool-idle-timeout", (Function1 & Serializable & scala.Serializable)configKey -> KubernetesClientImpl$.durationFomConfig$1(configKey, appConfig), new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds(), appConfig);
        Predef$.MODULE$.require(watchContinuouslyIdleTimeout.$greater((Object)watchContinuouslyRequestTimeout));
        if (logConfig.logConfiguration()) {
            LoggingAdapter log = Logging$.MODULE$.getLogger(actorSystem, (Object)"skuber.api");
            log.info("Using following context for connecting to Kubernetes cluster: {}", (Object)k8sContext);
        }
        Option<SSLContext> sslContext = TLS$.MODULE$.establishSSLContext(k8sContext);
        String string = k8sContext.namespace().name();
        String theNamespaceName = "".equals(string) ? "default" : string;
        Function2 & Serializable & scala.Serializable requestMaker = (Function2 & Serializable & scala.Serializable)(uri, method) -> HttpRequest$.MODULE$.apply(method, uri, HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        ConnectionPoolSettingsImpl defaultClientSettings = ConnectionPoolSettings$.MODULE$.apply(actorSystem.settings().config());
        ClientConnectionSettings watchConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(watchIdleTimeout);
        ConnectionPoolSettings watchSettings = defaultClientSettings.withConnectionSettings(watchConnectionSettings);
        ClientConnectionSettings podLogConnectionSettings = defaultClientSettings.connectionSettings().withIdleTimeout(podLogIdleTimeout);
        ConnectionPoolSettings podLogSettings = defaultClientSettings.withConnectionSettings(podLogConnectionSettings);
        return new KubernetesClientImpl((Function2<Uri, HttpMethod, HttpRequest>)requestMaker, k8sContext.cluster().server(), k8sContext.authInfo(), theNamespaceName, watchContinuouslyRequestTimeout, watchContinuouslyIdleTimeout, watchPoolIdleTimeout, watchSettings, podLogSettings, sslContext, logConfig, closeHook, actorSystem, dispatcher);
    }

    private static final Object getSkuberConfig$1(String key, Function1 fromConfig, Object object, Config appConfig$1) {
        String skuberConfigKey = new StringBuilder(7).append("skuber.").append(key).toString();
        if (appConfig$1.getIsNull(skuberConfigKey)) {
            return object;
        }
        Option option = (Option)fromConfig.apply((Object)skuberConfigKey);
        if (None$.MODULE$.equals(option)) {
            return object;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object t = some.value();
            return t;
        }
        throw new MatchError((Object)option);
    }

    private static final Option dispatcherFromConfig$1(String configKey, Config appConfig$1, ActorSystem actorSystem$1) {
        if (appConfig$1.getString(configKey).isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)actorSystem$1.dispatchers().lookup(appConfig$1.getString(configKey)));
    }

    private static final Option durationFomConfig$1(String configKey, Config appConfig$1) {
        return new Some((Object)Duration$.MODULE$.fromNanos(appConfig$1.getDuration(configKey).toNanos()));
    }

    private KubernetesClientImpl$() {
        MODULE$ = this;
    }
}

