/*
 * Decompiled with CFR 0.152.
 */
package skuber.api.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import skuber.api.security.SecurityHelper;
import skuber.api.security.SecurityHelper$PKCS1PrivateKeyParser$;
import skuber.api.security.SecurityHelper$PKCS8ECPrivateKeyParser$;
import skuber.api.security.SecurityHelper$PKCS8PrivateKeyParser$;

public final class SecurityHelper$ {
    public static SecurityHelper$ MODULE$;
    private final SecurityHelper.PEMHeaderFooter pkcs1PrivateKeyHdrFooter;
    private final SecurityHelper.PEMHeaderFooter pkcs8PrivateKeyHdrFooter;
    private final SecurityHelper.PEMHeaderFooter pkcs8ECPrivateKeyHdrFooter;
    private final List<SecurityHelper.PrivateKeyParser> privateKeyParsers;

    static {
        new SecurityHelper$();
    }

    public List<X509Certificate> readCertificates(InputStream is) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(CertificateFactory.getInstance("X509").generateCertificates(is)).asScala()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Certificate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)A1;
                    return (B1)x509Certificate;
                }
                throw new Exception("Not X509 cert?");
            }

            public final boolean isDefinedAt(Certificate x1) {
                Certificate certificate = x1;
                if (certificate instanceof X509Certificate) {
                    return true;
                }
                return true;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private InputStream createInputStreamForPathOrData(Either<String, byte[]> target) {
        Either<String, byte[]> either = target;
        if (either instanceof Right) {
            Right right = (Right)either;
            byte[] data = (byte[])right.value();
            return new ByteArrayInputStream(data);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String path = (String)left.value();
            Path filePath = Paths.get(path, new String[0]);
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        throw new MatchError(either);
    }

    public List<X509Certificate> getCertificates(Either<String, byte[]> from) {
        InputStream is = this.createInputStreamForPathOrData(from);
        return this.readCertificates(is);
    }

    public KeyStore createTrustStore(List<X509Certificate> apiServerCerts) {
        KeyStore trustStore2 = KeyStore.getInstance("JKS");
        trustStore2.load(null);
        return (KeyStore)apiServerCerts.foldLeft((Object)trustStore2, (Function2 & Serializable & scala.Serializable)(trustStore, apiServerCert) -> {
            String alias = apiServerCert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, (Certificate)apiServerCert);
            return trustStore;
        });
    }

    public KeyStore createKeyStore(String user, List<X509Certificate> clientCertificates, PrivateKey clientPrivateKey, Option<String> password) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        char[] keyStorePassword = ((String)password.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"changeit")).get()).toCharArray();
        keyStore.load(null, keyStorePassword);
        keyStore.setKeyEntry(user, clientPrivateKey, keyStorePassword, (Certificate[])clientCertificates.toArray(ClassTag$.MODULE$.apply(Certificate.class)));
        return keyStore;
    }

    public Option<String> createKeyStore$default$4() {
        return None$.MODULE$;
    }

    public PrivateKey getPrivateKey(Either<String, byte[]> from) {
        InputStream is = this.createInputStreamForPathOrData(from);
        return this.readPrivateKey(is);
    }

    private PrivateKey readPrivateKey(InputStream is) {
        String pemData = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return (PrivateKey)this.extractKeyFromPEMData(pemData).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Private key not in a supported PEM format");
        });
    }

    public SecurityHelper.PEMHeaderFooter pkcs1PrivateKeyHdrFooter() {
        return this.pkcs1PrivateKeyHdrFooter;
    }

    public SecurityHelper.PEMHeaderFooter pkcs8PrivateKeyHdrFooter() {
        return this.pkcs8PrivateKeyHdrFooter;
    }

    public SecurityHelper.PEMHeaderFooter pkcs8ECPrivateKeyHdrFooter() {
        return this.pkcs8ECPrivateKeyHdrFooter;
    }

    private List<SecurityHelper.PrivateKeyParser> privateKeyParsers() {
        return this.privateKeyParsers;
    }

    private Option<SecurityHelper.PrivateKeyParser> findPrivateKeyParser(String pemData) {
        return this.privateKeyParsers().find((Function1 & Serializable & scala.Serializable)parser -> BoxesRunTime.boxToBoolean((boolean)pemData.startsWith(parser.headerFooter().header())));
    }

    private Option<PrivateKey> extractKeyFromPEMData(String pemData) {
        Option<SecurityHelper.PrivateKeyParser> parserOpt = this.findPrivateKeyParser(pemData);
        return parserOpt.map((Function1 & Serializable & scala.Serializable)parser -> {
            String base64EncodedKey = pemData.replace(parser.headerFooter().header(), "").replace(parser.headerFooter().footer(), "");
            byte[] encoded = Base64.decodeBase64((String)base64EncodedKey);
            return parser.getPrivateKey(encoded);
        });
    }

    private SecurityHelper$() {
        MODULE$ = this;
        this.pkcs1PrivateKeyHdrFooter = new SecurityHelper.PEMHeaderFooter("-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
        this.pkcs8PrivateKeyHdrFooter = new SecurityHelper.PEMHeaderFooter("-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
        this.pkcs8ECPrivateKeyHdrFooter = new SecurityHelper.PEMHeaderFooter("-----BEGIN EC PRIVATE KEY-----", "-----END EC PRIVATE KEY-----");
        this.privateKeyParsers = new .colon.colon((Object)SecurityHelper$PKCS1PrivateKeyParser$.MODULE$, (List)new .colon.colon((Object)SecurityHelper$PKCS8PrivateKeyParser$.MODULE$, (List)new .colon.colon((Object)SecurityHelper$PKCS8ECPrivateKeyParser$.MODULE$, (List)Nil$.MODULE$)));
    }
}

