/*
 * Decompiled with CFR 0.152.
 */
package skuber.api.security;

import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.util.Either;
import scala.util.matching.Regex;
import skuber.api.client.Context;
import skuber.api.client.package;
import skuber.api.security.SecurityHelper$;
import skuber.api.security.TLS$InsecureSkipTLSVerifyTrustManager$;

public final class TLS$ {
    public static TLS$ MODULE$;
    private final TrustManager[] skipTLSTrustManagers;
    private final Regex HttpsPattern;
    private final Regex HttpPattern;

    static {
        new TLS$();
    }

    public TrustManager[] skipTLSTrustManagers() {
        return this.skipTLSTrustManagers;
    }

    public Regex HttpsPattern() {
        return this.HttpsPattern;
    }

    public Regex HttpPattern() {
        return this.HttpPattern;
    }

    public Option<SSLContext> establishSSLContext(Context k8sContext) {
        String string = k8sContext.cluster().server();
        Option option = this.HttpPattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty()) {
            return None$.MODULE$;
        }
        Option option2 = this.HttpsPattern().unapplySeq((CharSequence)string);
        if (!option2.isEmpty()) {
            return new Some((Object)this.buildSSLContext(k8sContext));
        }
        throw new Exception(new StringBuilder(77).append("Kubernetes cluster API server URL does not begin with either http or https : ").append(k8sContext.cluster().server()).toString());
    }

    private SSLContext buildSSLContext(Context k8sContext) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        boolean skipTLSVerify = k8sContext.cluster().insecureSkipTLSVerify();
        Option<Either<String, byte[]>> clusterCertConfig = k8sContext.cluster().certificateAuthority();
        Option<TrustManager[]> trustManagers = this.getTrustManagers(skipTLSVerify, clusterCertConfig);
        Option<KeyManager[]> keyManagers = this.getKeyManagers(k8sContext.authInfo());
        sslContext.init((KeyManager[])keyManagers.orNull(Predef$.MODULE$.$conforms()), (TrustManager[])trustManagers.orNull(Predef$.MODULE$.$conforms()), new SecureRandom());
        return sslContext;
    }

    private Option<TrustManager[]> getTrustManagers(boolean skipTLSVerify, Option<Either<String, byte[]>> serverCertConfig) {
        if (skipTLSVerify) {
            return new Some((Object)this.skipTLSTrustManagers());
        }
        return serverCertConfig.map((Function1 & Serializable & scala.Serializable)certPathOrData -> {
            List<X509Certificate> clusterServerCerts = SecurityHelper$.MODULE$.getCertificates((Either<String, byte[]>)certPathOrData);
            KeyStore trustStore = SecurityHelper$.MODULE$.createTrustStore(clusterServerCerts);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            return tmf.getTrustManagers();
        });
    }

    private Option<KeyManager[]> getKeyManagers(package.AuthInfo authInfo) {
        package.AuthInfo authInfo2 = authInfo;
        if (authInfo2 instanceof package.CertAuth) {
            package.CertAuth certAuth = (package.CertAuth)authInfo2;
            Either<String, byte[]> clientCert = certAuth.clientCertificate();
            Either<String, byte[]> clientKey = certAuth.clientKey();
            Option<String> userName = certAuth.user();
            List<X509Certificate> certs = SecurityHelper$.MODULE$.getCertificates(clientCert);
            PrivateKey key = SecurityHelper$.MODULE$.getPrivateKey(clientKey);
            KeyStore keyStore = SecurityHelper$.MODULE$.createKeyStore((String)userName.getOrElse((Function0 & Serializable & scala.Serializable)() -> "skuber"), certs, key, SecurityHelper$.MODULE$.createKeyStore$default$4());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, "changeit".toCharArray());
            return new Some((Object)kmf.getKeyManagers());
        }
        return None$.MODULE$;
    }

    private TLS$() {
        MODULE$ = this;
        this.skipTLSTrustManagers = (TrustManager[])((Object[])new TrustManager[]{TLS$InsecureSkipTLSVerifyTrustManager$.MODULE$});
        this.HttpsPattern = new StringOps(Predef$.MODULE$.augmentString("https:.*")).r();
        this.HttpPattern = new StringOps(Predef$.MODULE$.augmentString("http:.*")).r();
    }
}

