/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.maven;

import java.lang.reflect.Field;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagonAuthenticator;
import org.apache.maven.wagon.providers.http.LightweightHttpsWagon;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.sisu.Priority;

@Named(value="basic")
@Singleton
@Priority(value=100)
final class BasicWagonProvider
implements WagonProvider {
    BasicWagonProvider() {
    }

    public Wagon lookup(String roleHint) {
        switch (roleHint) {
            case "http": {
                return this.setAuthenticator(new LightweightHttpWagon());
            }
            case "https": {
                return this.setAuthenticator(new LightweightHttpsWagon());
            }
            case "file": {
                return new FileWagon();
            }
        }
        throw new IllegalArgumentException();
    }

    public void release(Wagon wagon) {
    }

    private <W extends LightweightHttpWagon> W setAuthenticator(W wagon) {
        try {
            Field authenticator = LightweightHttpWagon.class.getDeclaredField("authenticator");
            authenticator.setAccessible(true);
            authenticator.set(wagon, new LightweightHttpWagonAuthenticator());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        wagon.setPreemptiveAuthentication(true);
        return wagon;
    }
}

