/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.maven;

import io.smallrye.beanbag.BeanBag;
import io.smallrye.beanbag.DependencyFilter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;

@Named
@Priority(value=-100)
@Singleton
class PlexusContainerImpl
implements PlexusContainer {
    private final BeanBag bb;

    @Inject
    public PlexusContainerImpl(BeanBag bb) {
        this.bb = bb;
    }

    public Context getContext() {
        throw PlexusContainerImpl.uns();
    }

    public Object lookup(String role) throws ComponentLookupException {
        try {
            return this.bb.requireBean(Class.forName(role));
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role, null);
        }
    }

    public Object lookup(String role, String hint) throws ComponentLookupException {
        try {
            return this.bb.requireBean(Class.forName(role), hint);
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role, hint);
        }
    }

    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        try {
            return (T)this.bb.requireBean(role);
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role.getName(), null);
        }
    }

    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        try {
            return (T)this.bb.requireBean(role, hint);
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role.getName(), hint);
        }
    }

    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return type.cast(this.lookup(role, hint));
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role, hint);
        }
    }

    public List<Object> lookupList(String role) throws ComponentLookupException {
        try {
            return List.copyOf(this.bb.getAllBeans(Class.forName(role)));
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role, null);
        }
    }

    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        try {
            return Collections.checkedList(this.bb.getAllBeans(role), role);
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role.getName(), null);
        }
    }

    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        try {
            return Map.copyOf(this.bb.newScope().getAllBeansWithNames(Class.forName(role), DependencyFilter.ACCEPT));
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role, null);
        }
    }

    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        try {
            return Map.copyOf(this.bb.newScope().getAllBeansWithNames(role, DependencyFilter.ACCEPT));
        }
        catch (Exception e) {
            throw new ComponentLookupException((Throwable)e, role.getName(), null);
        }
    }

    public boolean hasComponent(String role) {
        try {
            return this.bb.getOptionalBean(Class.forName(role)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasComponent(String role, String hint) {
        try {
            return this.bb.getOptionalBean(Class.forName(role), hint) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasComponent(Class<?> role) {
        try {
            return this.bb.getOptionalBean(role) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasComponent(Class<?> role, String hint) {
        try {
            return this.bb.getOptionalBean(role, hint) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasComponent(Class<?> type, String role, String hint) {
        try {
            return type.cast(this.bb.getOptionalBean(Class.forName(role), hint)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addComponent(Object component, String role) {
        throw PlexusContainerImpl.uns();
    }

    public <T> void addComponent(T component, Class<?> role, String hint) {
        throw PlexusContainerImpl.uns();
    }

    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor) throws CycleDetectedInComponentGraphException {
        throw PlexusContainerImpl.uns();
    }

    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        throw PlexusContainerImpl.uns();
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String hint) {
        throw PlexusContainerImpl.uns();
    }

    public List<ComponentDescriptor<?>> getComponentDescriptorList(String role) {
        throw PlexusContainerImpl.uns();
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        throw PlexusContainerImpl.uns();
    }

    public Map<String, ComponentDescriptor<?>> getComponentDescriptorMap(String role) {
        throw PlexusContainerImpl.uns();
    }

    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        throw PlexusContainerImpl.uns();
    }

    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm classRealm) throws PlexusConfigurationException {
        throw PlexusContainerImpl.uns();
    }

    public ClassRealm getContainerRealm() {
        throw PlexusContainerImpl.uns();
    }

    public ClassRealm setLookupRealm(ClassRealm realm) {
        throw PlexusContainerImpl.uns();
    }

    public ClassRealm getLookupRealm() {
        throw PlexusContainerImpl.uns();
    }

    public ClassRealm createChildRealm(String id) {
        throw PlexusContainerImpl.uns();
    }

    public void release(Object component) {
    }

    public void releaseAll(Map<String, ?> components) {
    }

    public void releaseAll(List<?> components) {
    }

    public void dispose() {
    }

    private static UnsupportedOperationException uns() {
        return new UnsupportedOperationException();
    }
}

