/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.sisu;

import io.smallrye.beanbag.BeanBag;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.common.constraint.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Provider;

public final class Sisu {
    private final Set<Class<?>> visited = new HashSet();
    private final BeanBag.Builder builder;
    private static final ClassValue<Class<?>> arrayTypes = new ClassValue<Class<?>>(){

        @Override
        protected Class<?> computeValue(Class<?> type) {
            return Array.newInstance(type, 0).getClass();
        }
    };
    private static final ClassValue<Function<Annotation, String>> GET_NAMED_VALUE_FN = new ClassValue<Function<Annotation, String>>(){

        @Override
        protected Function<Annotation, String> computeValue(Class<?> type) {
            return new MethodFunction<String>(type, "javax.inject.Named");
        }
    };
    private static final ClassValue<Function<Annotation, Integer>> GET_PRIORITY_VALUE_FN = new ClassValue<Function<Annotation, Integer>>(){

        @Override
        protected Function<Annotation, Integer> computeValue(Class<?> type) {
            return new MethodFunction<Integer>(type, "org.eclipse.sisu.Priority");
        }
    };
    private static final ClassValue<Function<Annotation, Class<?>[]>> GET_TYPED_VALUE_FN = new ClassValue<Function<Annotation, Class<?>[]>>(){

        @Override
        protected Function<Annotation, Class<?>[]> computeValue(Class<?> type) {
            return new MethodFunction<Class<?>[]>(type, "org.eclipse.sisu.Typed");
        }
    };

    private Sisu(BeanBag.Builder builder) {
        this.builder = builder;
    }

    public void addClassLoader(ClassLoader classLoader, DependencyFilter filter) {
        Assert.checkNotNullParam((String)"classLoader", (Object)classLoader);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        try {
            Enumeration<URL> e = classLoader.getResources("META-INF/sisu/javax.inject.Named");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                URLConnection conn = url.openConnection();
                InputStream is = conn.getInputStream();
                try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(isr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        Class<?> clazz;
                        String className;
                        int idx = line.indexOf(35);
                        if (idx != -1) {
                            line = line.substring(0, idx);
                        }
                        if ((className = line.trim()).isBlank()) continue;
                        try {
                            clazz = Class.forName(className, false, classLoader);
                        }
                        catch (ClassNotFoundException | LinkageError ex) {
                            continue;
                        }
                        this.addClass(clazz, filter);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> void addClass(Class<T> clazz, DependencyFilter filter) {
        List<Class<?>> typed;
        Assert.checkNotNullParam((String)"clazz", clazz);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        if (!this.visited.add(clazz)) {
            return;
        }
        BeanBag.BeanBuilder beanBuilder = this.builder.addBean(clazz);
        Annotations clazzAnnotations = Annotations.of(clazz);
        String named = clazzAnnotations.getNamed();
        if (named != null) {
            beanBuilder.setName(named);
        }
        if ((typed = clazzAnnotations.getTyped()) != null) {
            beanBuilder.addRestrictedTypes(typed);
        }
        if (clazzAnnotations.isSingleton()) {
            beanBuilder.setSingleton(true);
        }
        if (clazzAnnotations.hasPriority()) {
            int pv = clazzAnnotations.getPriority();
            if (pv >= 0 && named != null && named.equals("default")) {
                pv -= Integer.MIN_VALUE;
            }
            beanBuilder.setPriority(pv);
        }
        BeanBag.SupplierBuilder supplierBuilder = beanBuilder.buildSupplier();
        Constructor<T> ctor = Sisu.findConstructor(clazz);
        for (Parameter parameter : ctor.getParameters()) {
            Annotations paramAnnotations = Annotations.of(parameter);
            boolean optional = paramAnnotations.isNullable();
            String paramNamed = paramAnnotations.getNamed();
            String name = paramNamed == null ? "" : paramNamed;
            Class<?> parameterType = parameter.getType();
            supplierBuilder.addConstructorArgument(Sisu.getSupplier(parameterType, parameter.getParameterizedType(), name, optional, filter));
        }
        supplierBuilder.setConstructor(ctor);
        Sisu.addFieldInjections(clazz, supplierBuilder, filter);
        Sisu.addMethodInjections(clazz, supplierBuilder, filter);
        supplierBuilder.build();
        beanBuilder.build();
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            if (Sisu.getRawType(genericInterface) != Provider.class) continue;
            Sisu.addOneProvider(this.builder, genericInterface, clazz.asSubclass(Provider.class), clazzAnnotations);
        }
    }

    public static void configureSisu(ClassLoader classLoader, BeanBag.Builder builder, DependencyFilter filter) {
        Sisu.createFor(builder).addClassLoader(classLoader, filter);
    }

    public static Sisu createFor(BeanBag.Builder builder) {
        Assert.checkNotNullParam((String)"builder", (Object)builder);
        return new Sisu(builder);
    }

    private static <T, P extends Provider<T>> void addOneProvider(BeanBag.Builder builder, Type genericInterface, Class<P> clazz, Annotations clazzAnnotations) {
        Class<?> providedType = Sisu.getRawType(Sisu.getTypeArgument(genericInterface, 0));
        BeanBag.BeanBuilder providedBuilder = builder.addBean(providedType);
        String named = clazzAnnotations.getNamed();
        if (named != null) {
            providedBuilder.setName(named);
        }
        if (clazzAnnotations.hasPriority()) {
            int pv = clazzAnnotations.getPriority();
            if (pv >= 0 && named != null && named.equals("default")) {
                pv -= Integer.MIN_VALUE;
            }
            providedBuilder.setPriority(pv);
        }
        String name = named == null ? "" : named;
        providedBuilder.setSupplier(BeanSupplier.resolving(clazz, (String)name, (boolean)false, (DependencyFilter)DependencyFilter.ACCEPT).transform(Provider::get));
        providedBuilder.build();
    }

    private static BeanSupplier<?> getSupplier(Class<?> rawType, Type parameterizedType, String name, boolean optional, DependencyFilter filter) {
        if (rawType == Provider.class) {
            Type providerType = Sisu.getTypeArgument(parameterizedType, 0);
            BeanSupplier<?> supplier = Sisu.getSupplier(Sisu.getRawType(providerType), providerType, name, optional, filter);
            return scope -> () -> supplier.get(scope);
        }
        if (rawType == Set.class) {
            Class<?> argType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            return BeanSupplier.resolvingAll(argType, (String)name, (DependencyFilter)filter).transform(Set::copyOf);
        }
        if (rawType == List.class || rawType == Collection.class) {
            Class<?> argType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            return BeanSupplier.resolvingAll(argType, (String)name, (DependencyFilter)filter);
        }
        if (rawType == Map.class) {
            Class<?> keyType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            Class<?> valType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 1));
            if (keyType == String.class) {
                return BeanSupplier.resolvingAllByName(valType, (DependencyFilter)filter);
            }
            throw new IllegalArgumentException("Invalid key type " + keyType + " for map");
        }
        return BeanSupplier.resolving(rawType, (String)(name == null ? "" : name), (boolean)optional, (DependencyFilter)filter);
    }

    private static Type getTypeArgument(Type type, int position) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments()[position];
        }
        throw new IllegalArgumentException("No type argument given for " + type);
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return Sisu.getRawType(pt.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Sisu.getArrayType(Sisu.getRawType(gat.getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] ub = wt.getUpperBounds();
            return ub.length >= 1 ? Sisu.getRawType(ub[0]) : Object.class;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            return bounds.length >= 1 ? Sisu.getRawType(bounds[0]) : Object.class;
        }
        throw new IllegalArgumentException("Cannot determine raw type of " + type);
    }

    private static <T> Class<T[]> getArrayType(Class<T> elementType) {
        return arrayTypes.get(elementType);
    }

    private static <T> void addFieldInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter) {
        if (clazz == Object.class) {
            return;
        }
        Class<? super T> superclass = clazz.getSuperclass();
        if (superclass != null) {
            Sisu.addFieldInjections(superclass, supplierBuilder, filter);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Annotations fieldAnnotations;
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || !(fieldAnnotations = Annotations.of(field)).isInject()) continue;
            field.setAccessible(true);
            boolean optional = fieldAnnotations.isNullable();
            String paramNamed = fieldAnnotations.getNamed();
            String name = paramNamed == null ? "" : paramNamed;
            Class<?> fieldType = field.getType();
            supplierBuilder.injectField(field, Sisu.getSupplier(fieldType, field.getGenericType(), name, optional, filter));
        }
    }

    private static <T> void addMethodInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter) {
        Sisu.addMethodInjections(clazz, supplierBuilder, filter, new HashSet<Class<? super T>>());
    }

    private static <T> void addMethodInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter, Set<Class<? super T>> visited) {
        if (visited.add(clazz)) {
            if (clazz == Object.class) {
                return;
            }
            Class<T> superclass = clazz.getSuperclass();
            if (superclass != null) {
                Sisu.addMethodInjections(superclass, supplierBuilder, filter);
            }
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                Sisu.addMethodInjections(clazz2, supplierBuilder, filter);
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                Annotations methodAnnotations;
                int mods = ((Method)genericDeclaration).getModifiers();
                if (Modifier.isStatic(mods) || !(methodAnnotations = Annotations.of(genericDeclaration)).isInject() || ((Method)genericDeclaration).getParameterCount() != 1) continue;
                String named = methodAnnotations.getNamed();
                String name = named == null ? "" : named;
                Parameter argParam = ((Executable)genericDeclaration).getParameters()[0];
                boolean optional = Annotations.of(argParam).isNullable();
                supplierBuilder.injectMethod((Method)genericDeclaration, argParam.getType(), name, optional, filter);
            }
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz) {
        Constructor<?>[] declaredConstructors;
        Constructor<?> defaultConstructor = null;
        try {
            declaredConstructors = clazz.getDeclaredConstructors();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get declared constructors from " + clazz, t);
        }
        for (Constructor<?> constructor : declaredConstructors) {
            if (Annotations.of(constructor).isInject()) {
                constructor.setAccessible(true);
                return constructor;
            }
            if (constructor.getParameterCount() != 0) continue;
            defaultConstructor = constructor;
        }
        if (defaultConstructor != null) {
            defaultConstructor.setAccessible(true);
            return defaultConstructor;
        }
        throw new RuntimeException("No valid constructor found on " + clazz);
    }

    static class Annotations {
        private final boolean hasPriority;
        private final int priority;
        private final String named;
        private final boolean inject;
        private final boolean singleton;
        private final boolean nullable;
        private final List<Class<?>> typed;

        private Annotations(AnnotatedElement element) {
            boolean hasPriority = false;
            int priority = 0;
            String named = null;
            boolean inject = false;
            boolean singleton = false;
            boolean nullable = false;
            List<Class<?>> typed = null;
            block19: for (Annotation annotation : element.getAnnotations()) {
                String annoName;
                Class<? extends Annotation> annoType = annotation.annotationType();
                switch (annoName = annoType.getName()) {
                    case "javax.inject.Inject": {
                        inject = true;
                        continue block19;
                    }
                    case "javax.inject.Singleton": 
                    case "org.eclipse.sisu.EagerSingleton": 
                    case "org.sonatype.inject.EagerSingleton": {
                        singleton = true;
                        continue block19;
                    }
                    case "javax.inject.Named": {
                        named = GET_NAMED_VALUE_FN.get(annoType).apply(annotation);
                        continue block19;
                    }
                    case "org.eclipse.sisu.Nullable": 
                    case "org.sonatype.inject.Nullable": {
                        nullable = true;
                        continue block19;
                    }
                    case "org.eclipse.sisu.Priority": {
                        priority = GET_PRIORITY_VALUE_FN.get(annoType).apply(annotation);
                        continue block19;
                    }
                    case "org.eclipse.sisu.Typed": {
                        typed = List.of(GET_TYPED_VALUE_FN.get(annoType).apply(annotation));
                    }
                }
            }
            this.hasPriority = hasPriority;
            this.priority = priority;
            this.named = named;
            this.inject = inject;
            this.singleton = singleton;
            this.nullable = nullable;
            this.typed = typed;
        }

        static Annotations of(AnnotatedElement element) {
            return new Annotations(element);
        }

        boolean hasPriority() {
            return this.hasPriority;
        }

        int getPriority() {
            return this.priority;
        }

        String getNamed() {
            return this.named;
        }

        boolean isInject() {
            return this.inject;
        }

        boolean isSingleton() {
            return this.singleton;
        }

        boolean isNullable() {
            return this.nullable;
        }

        List<Class<?>> getTyped() {
            return this.typed;
        }
    }

    static class MethodFunction<R>
    implements Function<Annotation, R> {
        private final Method method;

        MethodFunction(Class<?> type, String expectedName) {
            Method method;
            Class<Annotation> annotationType = type.asSubclass(Annotation.class);
            if (!annotationType.getName().equals(expectedName)) {
                throw new IllegalArgumentException("Wrong class name");
            }
            try {
                method = annotationType.getDeclaredMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.method = method;
        }

        @Override
        public R apply(Annotation annotation) {
            try {
                return (R)this.method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

