/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.FieldInjector;
import io.smallrye.beanbag.MethodInjector;
import io.smallrye.beanbag.Scope;
import io.smallrye.common.constraint.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

interface Injector<C> {
    public void injectInto(Scope var1, C var2);

    public static <C, T> Injector<C> forField(Field field, BeanSupplier<T> supplier) {
        Assert.checkNotNullParam((String)"field", (Object)field);
        Assert.checkNotNullParam((String)"supplier", supplier);
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods)) {
            throw new IllegalArgumentException("Cannot inject into final field " + field.getDeclaringClass().getSimpleName());
        }
        if (Modifier.isStatic(mods)) {
            throw new IllegalArgumentException("Cannot inject into static field " + field.getDeclaringClass().getSimpleName());
        }
        return new FieldInjector(field, supplier);
    }

    public static <C, T> Injector<C> forSetterMethod(Method method, BeanSupplier<T> supplier) {
        Assert.checkNotNullParam((String)"method", (Object)method);
        Assert.checkNotNullParam((String)"supplier", supplier);
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods)) {
            throw new IllegalArgumentException("Cannot inject into static method " + method.getDeclaringClass().getSimpleName());
        }
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Cannot inject into method with more than one argument");
        }
        return new MethodInjector(method, supplier);
    }
}

