/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.maven;

import io.smallrye.certs.AliasRequest;
import io.smallrye.certs.CertificateGenerator;
import io.smallrye.certs.CertificateRequest;
import io.smallrye.certs.Format;
import io.smallrye.certs.maven.AliasParameter;
import io.smallrye.certs.maven.CertificateRequestParameter;
import java.io.File;
import java.time.Duration;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, threadSafe=true, requiresProject=true)
public class CertificatesGeneratorMojo
extends AbstractMojo {
    @Parameter(required=true)
    private List<CertificateRequestParameter> certificates;
    @Parameter(property="certificate-generator.outputDirectory", defaultValue="${project.build.directory}/certificates")
    private String outputDirectory;
    @Parameter(property="certificate-generator.replaceIfExists", defaultValue="false")
    private boolean replaceIfExists;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating certificates");
        File out = new File(this.outputDirectory);
        if (!out.isDirectory()) {
            out.mkdirs();
        }
        try {
            CertificateGenerator generator = new CertificateGenerator(new File(this.outputDirectory).toPath(), this.replaceIfExists);
            for (CertificateRequestParameter request : this.certificates) {
                CertificateRequest cr = new CertificateRequest().withName(request.getName()).withFormats(request.getFormats().stream().map(String::toUpperCase).map(Format::valueOf).toList()).withClientCertificate(request.isClient()).withCN(request.getCn()).withPassword(request.getPassword()).withDuration(Duration.ofDays(request.getDuration()));
                if (request.getSubjectAlternativeNames() != null) {
                    for (String subjectAlternativeName : request.getSubjectAlternativeNames()) {
                        cr.withSubjectAlternativeName(subjectAlternativeName);
                    }
                }
                if (request.getAliases() != null) {
                    for (AliasParameter alias : request.getAliases()) {
                        AliasRequest req = new AliasRequest().withClientCertificate(alias.isClient()).withPassword(alias.getPassword()).withCN(alias.getCn());
                        if (alias.getSubjectAlternativeNames() != null) {
                            for (String subjectAlternativeName : alias.getSubjectAlternativeNames()) {
                                req.withSubjectAlternativeName(subjectAlternativeName);
                            }
                        }
                        cr.withAlias(alias.getName(), req);
                    }
                }
                generator.generate(cr);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate certificates", e);
        }
    }

    public void setCertificates(List<CertificateRequestParameter> requests) {
        this.certificates = requests;
    }
}

