/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.cpu;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Locale;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProcessorInfo {
    private static final String CPUS_ALLOWED = "Cpus_allowed:";

    private ProcessorInfo() {
    }

    public static int availableProcessors() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> ProcessorInfo.determineProcessors());
        }
        return ProcessorInfo.determineProcessors();
    }

    private static int determineProcessors() {
        int javaProcs = Runtime.getRuntime().availableProcessors();
        if (!ProcessorInfo.isLinux()) {
            return javaProcs;
        }
        int maskProcs = 0;
        try {
            maskProcs = ProcessorInfo.readCPUMask();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maskProcs > 0 ? Math.min(javaProcs, maskProcs) : javaProcs;
    }

    private static int readCPUMask() throws IOException {
        try (FileInputStream stream = new FileInputStream("/proc/self/status");
             InputStreamReader inputReader = new InputStreamReader((InputStream)stream, StandardCharsets.US_ASCII);
             BufferedReader reader = new BufferedReader(inputReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                int start;
                if (!line.startsWith(CPUS_ALLOWED)) continue;
                int count = 0;
                for (int i = start = CPUS_ALLOWED.length(); i < line.length(); ++i) {
                    int v = Character.digit(line.charAt(i), 16);
                    if (v == -1) continue;
                    count += Integer.bitCount(v);
                }
                int n = count;
                return n;
            }
        }
        return -1;
    }

    private static boolean isLinux() {
        String osArch = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
        return osArch.contains("linux");
    }
}

