/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.VersionSyntaxException;
import java.math.BigInteger;
import java.util.NoSuchElementException;

public interface VersionIterator {
    public boolean hasNext();

    public void next() throws NoSuchElementException, VersionSyntaxException;

    public int length();

    default public boolean isSeparator() {
        return this.isEmptySeparator() || this.isNonEmptySeparator();
    }

    default public boolean isPart() {
        return this.isAlphaPart() || this.isNumberPart();
    }

    public boolean isEmptySeparator();

    public boolean isNonEmptySeparator();

    public int getSeparatorCodePoint();

    public boolean isAlphaPart();

    public boolean isNumberPart();

    public String getAlphaPart() throws IllegalStateException;

    public StringBuilder appendAlphaPartTo(StringBuilder var1) throws IllegalStateException;

    default public boolean alphaPartEquals(String str, boolean ignoreCase) throws IllegalStateException {
        return this.alphaPartEquals(str, 0, str.length(), ignoreCase);
    }

    default public boolean alphaPartEquals(String str, int offs, int len, boolean ignoreCase) throws IllegalStateException, StringIndexOutOfBoundsException {
        return this.compareAlphaPart(str, offs, len, ignoreCase) == 0;
    }

    default public int compareAlphaPart(String str, boolean ignoreCase) throws IllegalStateException {
        return this.compareAlphaPart(str, 0, str.length(), ignoreCase);
    }

    public int compareAlphaPart(String var1, int var2, int var3, boolean var4) throws IllegalStateException, StringIndexOutOfBoundsException;

    public int compareAlphaPart(VersionIterator var1, boolean var2) throws IllegalStateException;

    default public String getNumberPartAsString() throws IllegalStateException {
        return this.appendNumberPartTo(new StringBuilder()).toString();
    }

    public StringBuilder appendNumberPartTo(StringBuilder var1) throws IllegalStateException;

    public long getNumberPartAsLong() throws IllegalStateException;

    public int getNumberPartAsInt() throws IllegalStateException;

    default public BigInteger getNumberPartAsBigInteger() throws IllegalStateException {
        return new BigInteger(this.getNumberPartAsString());
    }

    default public boolean numberPartEquals(int value) throws IllegalStateException {
        return this.compareNumberPart(value) == 0;
    }

    default public boolean numberPartEquals(long value) throws IllegalStateException {
        return this.compareNumberPart(value) == 0;
    }

    public int compareNumberPart(int var1) throws IllegalStateException;

    public int compareNumberPart(long var1) throws IllegalStateException;

    default public int compareNumberPart(String value) throws IllegalStateException {
        return this.compareNumberPart(value, 0, value.length());
    }

    public int compareNumberPart(String var1, int var2, int var3) throws IllegalStateException;

    public int compareNumberPart(VersionIterator var1);

    public StringBuilder appendPartTo(StringBuilder var1);
}

