/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.converter.json;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.microprofile.config.spi.Converter;

public class JsonArrayConverter
implements Converter<JsonArray> {
    public JsonArray convert(String input) {
        if (this.isNullOrEmpty(input)) {
            return null;
        }
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(input));){
            JsonArray jsonArray = jsonReader.readArray();
            return jsonArray;
        }
    }

    private boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }
}

