/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.converter.json;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.microprofile.config.spi.Converter;

public class JsonObjectConverter
implements Converter<JsonObject> {
    public JsonObject convert(String input) {
        if (this.isNullOrEmpty(input)) {
            return null;
        }
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(input));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    private boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }
}

