/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.crypto;

import io.smallrye.config.SecretKeysHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESGCMNoPaddingSecretKeysHandler
implements SecretKeysHandler {
    private final SecretKeySpec encryptionKey;

    public AESGCMNoPaddingSecretKeysHandler(byte[] encryptionKey) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(encryptionKey);
            this.encryptionKey = new SecretKeySpec(sha256.digest(), "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decode(String secret) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getUrlDecoder().decode(secret.getBytes(StandardCharsets.UTF_8)));
            byte ivLength = byteBuffer.get();
            byte[] iv = new byte[ivLength];
            byteBuffer.get(iv);
            byte[] encrypted = new byte[byteBuffer.remaining()];
            byteBuffer.get(encrypted);
            cipher.init(2, (Key)this.encryptionKey, new GCMParameterSpec(128, iv));
            return new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "aes-gcm-nopadding";
    }
}

