/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.jasypt;

import io.smallrye.config.SecretKeysHandler;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class JasyptSecretKeysHandler
implements SecretKeysHandler {
    private final StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();

    public JasyptSecretKeysHandler(String password, String algorithm) {
        this.encryptor.setPassword(password);
        this.encryptor.setAlgorithm(algorithm);
        this.encryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
        this.encryptor.initialize();
    }

    public String decode(String secret) {
        return PropertyValueEncryptionUtils.decrypt((String)secret, (StringEncryptor)this.encryptor);
    }

    public String getName() {
        return "jasypt";
    }
}

