/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.yaml;

import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigSource
extends MapBackedConfigSource {
    static final int ORDINAL = 110;
    private static final long serialVersionUID = -418186029484956531L;

    public YamlConfigSource(String name, InputStream stream) throws IOException {
        this(name, stream, 110);
    }

    public YamlConfigSource(String name, InputStream stream, int defaultOrdinal) throws IOException {
        super(name, YamlConfigSource.streamToMap(stream), defaultOrdinal, false);
    }

    public YamlConfigSource(String name, String str) {
        this(name, str, 110);
    }

    public YamlConfigSource(String name, String str, int defaultOrdinal) {
        super(name, YamlConfigSource.stringToMap(str), defaultOrdinal, false);
    }

    private static Map<String, String> streamToMap(InputStream inputStream) throws IOException {
        Map yamlInput;
        try {
            yamlInput = (Map)new Yaml().loadAs(inputStream, HashMap.class);
            inputStream.close();
        }
        catch (Throwable t) {
            try {
                inputStream.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return YamlConfigSource.yamlInputToMap(yamlInput);
    }

    private static Map<String, String> stringToMap(String str) {
        Map yamlInput = (Map)new Yaml().loadAs(str, HashMap.class);
        return YamlConfigSource.yamlInputToMap(yamlInput);
    }

    private static Map<String, String> yamlInputToMap(Map<String, Object> yamlInput) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        StringBuilder keyBuilder = new StringBuilder();
        YamlConfigSource.populateFromMapNode(properties, keyBuilder, yamlInput);
        return properties;
    }

    private static void populateFromMapNode(Map<String, String> properties, StringBuilder keyBuilder, Map<String, Object> o) {
        if (o == null) {
            return;
        }
        int len = keyBuilder.length();
        for (String nestedKey : o.keySet()) {
            if (nestedKey != null) {
                if (keyBuilder.length() > 0) {
                    keyBuilder.append('.');
                }
                if (nestedKey.indexOf(46) != -1) {
                    keyBuilder.append('\"');
                    YamlConfigSource.escapeQuotes(keyBuilder, nestedKey);
                    keyBuilder.append('\"');
                } else {
                    keyBuilder.append(nestedKey);
                }
            }
            YamlConfigSource.populateFromNode(properties, keyBuilder, o.get(nestedKey));
            keyBuilder.setLength(len);
        }
    }

    private static void populateFromNode(Map<String, String> properties, StringBuilder keyBuilder, Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            YamlConfigSource.populateFromMapNode(properties, keyBuilder, map);
        } else if (o instanceof List) {
            StringBuilder b = new StringBuilder();
            YamlConfigSource.populateFromEntryNode(b, o, 0);
            properties.put(keyBuilder.toString(), b.toString());
        } else if (o != null) {
            properties.put(keyBuilder.toString(), o.toString());
        } else {
            properties.put(keyBuilder.toString(), "");
        }
    }

    private static void populateFromEntryNode(StringBuilder valueBuilder, Object o, int escapeLevel) {
        String src;
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                YamlConfigSource.escapeMapKey(valueBuilder, (String)entry.getKey(), escapeLevel + 1);
                YamlConfigSource.appendEscaped(valueBuilder, '=', escapeLevel);
                YamlConfigSource.populateFromEntryNode(valueBuilder, o, escapeLevel + 1);
            }
        } else if (o instanceof List) {
            Iterator iterator = ((List)o).iterator();
            if (iterator.hasNext()) {
                YamlConfigSource.populateFromEntryNode(valueBuilder, iterator.next(), escapeLevel + 1);
                while (iterator.hasNext()) {
                    YamlConfigSource.appendEscaped(valueBuilder, ',', escapeLevel);
                    YamlConfigSource.populateFromEntryNode(valueBuilder, iterator.next(), escapeLevel + 1);
                }
            }
        } else if (o != null && !(src = o.toString()).isEmpty()) {
            YamlConfigSource.escapeCommas(valueBuilder, src, escapeLevel);
        }
    }

    private static void escape(StringBuilder b, int escapeLevel) {
        if (escapeLevel == 0) {
            return;
        }
        int count = 1 << escapeLevel - 1;
        for (int i = 0; i < count; ++i) {
            b.append('\\');
        }
    }

    private static void appendEscaped(StringBuilder b, char ch, int escapeLevel) {
        YamlConfigSource.escape(b, escapeLevel);
        b.append(ch);
    }

    private static void escapeQuotes(StringBuilder b, String src) {
        int cp;
        for (int i = 0; i < src.length(); i += Character.charCount(cp)) {
            cp = src.codePointAt(i);
            if (cp == 92 || cp == 34) {
                b.append('\\');
            }
            b.appendCodePoint(cp);
        }
    }

    private static void escapeCommas(StringBuilder b, String src, int escapeLevel) {
        int cp;
        for (int i = 0; i < src.length(); i += Character.charCount(cp)) {
            cp = src.codePointAt(i);
            if (cp == 92 || cp == 44) {
                for (int j = 0; j < escapeLevel; ++j) {
                    b.append('\\');
                }
            }
            b.appendCodePoint(cp);
        }
    }

    private static void escapeMapKey(StringBuilder b, String src, int escapeLevel) {
        int cp;
        for (int i = 0; i < src.length(); i += Character.charCount(cp)) {
            cp = src.codePointAt(i);
            if (cp == 92 || cp == 44) {
                for (int j = 0; j < escapeLevel; ++j) {
                    b.append('\\');
                }
            }
            b.appendCodePoint(cp);
        }
    }
}

