/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.yaml;

import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class YamlConfigSourceProvider
implements ConfigSourceProvider {
    private static final String META_INF_MICROPROFILE_CONFIG_RESOURCE = "META-INF/microprofile-config.yaml";
    private static final String WEB_INF_MICROPROFILE_CONFIG_RESOURCE = "WEB-INF/classes/META-INF/microprofile-config.yaml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<ConfigSource> getConfigSource(ClassLoader classLoader, String resource, int ordinal) {
        try {
            InputStream stream = classLoader.getResourceAsStream(resource);
            if (stream == null) return Optional.empty();
            try (InputStream c = stream;){
                Optional<YamlConfigSource> optional = Optional.of(new YamlConfigSource(resource, stream, ordinal));
                return optional;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader) {
        ArrayList configSources = new ArrayList(2);
        YamlConfigSourceProvider.getConfigSource(classLoader, META_INF_MICROPROFILE_CONFIG_RESOURCE, 120).ifPresent(configSources::add);
        YamlConfigSourceProvider.getConfigSource(classLoader, WEB_INF_MICROPROFILE_CONFIG_RESOURCE, 110).ifPresent(configSources::add);
        return Collections.unmodifiableList(configSources);
    }
}

