/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.yaml;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigSource
extends MapBackedConfigSource {
    static final int ORDINAL = 110;
    private static final long serialVersionUID = -418186029484956531L;
    private final Set<String> propertyNames;

    public YamlConfigSource(String name, Map<String, String> source, int ordinal) {
        super(name, source, ordinal, false);
        this.propertyNames = YamlConfigSource.filterIndexedNames(source.keySet());
    }

    public YamlConfigSource(String name, InputStream stream) throws IOException {
        this(name, stream, 110);
    }

    public YamlConfigSource(String name, InputStream stream, int defaultOrdinal) throws IOException {
        this(name, YamlConfigSource.streamToMap(stream), defaultOrdinal);
    }

    public YamlConfigSource(String name, String source) {
        this(name, source, 110);
    }

    public YamlConfigSource(String name, String source, int ordinal) {
        this(name, YamlConfigSource.stringToMap(source), ordinal);
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    private static Map<String, String> streamToMap(InputStream inputStream) throws IOException {
        Assert.checkNotNullParam((String)"inputStream", (Object)inputStream);
        TreeMap<String, String> yamlInput = new TreeMap<String, String>();
        try {
            Iterable objects = new Yaml().loadAll(inputStream);
            for (Object object : objects) {
                if (!(object instanceof Map)) continue;
                yamlInput.putAll(YamlConfigSource.yamlInputToMap((Map)object));
            }
            inputStream.close();
        }
        catch (Throwable t) {
            try {
                inputStream.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return yamlInput;
    }

    private static Map<String, String> stringToMap(String str) {
        Map yamlInput = (Map)new Yaml().loadAs(str, HashMap.class);
        return YamlConfigSource.yamlInputToMap(yamlInput);
    }

    private static Map<String, String> yamlInputToMap(Map<Object, Object> yamlInput) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        if (yamlInput != null) {
            YamlConfigSource.flattenYaml("", yamlInput, properties);
        }
        return properties;
    }

    private static void flattenYaml(String path, Map<Object, Object> source, Map<String, String> target) {
        source.forEach((originalKey, value) -> {
            String key = originalKey == null ? "" : originalKey.toString();
            if (key.contains(".")) {
                key = "\"" + key + "\"";
            }
            if (!key.isEmpty() && path != null && !path.isEmpty()) {
                key = path + "." + key;
            } else if (path != null && !path.isEmpty()) {
                key = path;
            }
            if (value instanceof String) {
                target.put(key, (String)value);
            } else if (value instanceof Map) {
                YamlConfigSource.flattenYaml(key, (Map)value, target);
            } else if (value instanceof List) {
                List list = (List)value;
                YamlConfigSource.flattenList(key, list, target);
                for (int i = 0; i < list.size(); ++i) {
                    YamlConfigSource.flattenYaml(key, Collections.singletonMap("[" + i + "]", list.get(i)), target);
                }
            } else {
                target.put(key, value != null ? value.toString() : "");
            }
        });
    }

    private static void flattenList(String key, List<Object> source, Map<String, String> target) {
        if (source.stream().allMatch(o -> o instanceof String)) {
            target.put(key, source.stream().map(o -> {
                StringBuilder sb = new StringBuilder();
                YamlConfigSource.escapeCommas(sb, o.toString(), 1);
                return sb.toString();
            }).collect(Collectors.joining(",")));
        } else {
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.FOLDED);
            target.put(key, new Yaml(dumperOptions).dump(Collections.singletonMap(key.substring(key.lastIndexOf(".") + 1), source)));
        }
    }

    private static void escapeCommas(StringBuilder b, String src, int escapeLevel) {
        int cp;
        for (int i = 0; i < src.length(); i += Character.charCount(cp)) {
            cp = src.codePointAt(i);
            if (cp == 92 || cp == 44) {
                for (int j = 0; j < escapeLevel; ++j) {
                    b.append('\\');
                }
            }
            b.appendCodePoint(cp);
        }
    }

    private static Set<String> filterIndexedNames(Set<String> names) {
        Pattern pattern = Pattern.compile(".*\\[[0-9]+].*");
        return names.stream().filter(s -> !pattern.matcher((CharSequence)s).find()).collect(Collectors.toSet());
    }
}

