/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.yaml;

import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = -418186029484956531L;
    private static final String NAME_PREFIX = "YamlConfigSource[source=";
    private static final int ORDINAL = 110;
    private static final Yaml DUMPER;
    private final Set<String> propertyNames;

    public YamlConfigSource(String name, Map<String, String> source, int ordinal) {
        super(name, source, ordinal, false);
        this.propertyNames = YamlConfigSource.filterPropertyNames(source);
    }

    @Deprecated
    public YamlConfigSource(String name, InputStream stream) throws IOException {
        this(name, stream, 110);
    }

    public YamlConfigSource(URL url) throws IOException {
        this(url, 110);
    }

    public YamlConfigSource(URL url, int ordinal) throws IOException {
        this(NAME_PREFIX + url.toString() + "]", (Map)ClassPathUtils.readStream((URL)url, inputStream -> {
            try {
                return YamlConfigSource.streamToMap(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), ordinal);
    }

    @Deprecated
    public YamlConfigSource(String name, InputStream stream, int defaultOrdinal) throws IOException {
        this(name, YamlConfigSource.streamToMap(stream), defaultOrdinal);
    }

    public YamlConfigSource(String name, String source) {
        this(name, source, 110);
    }

    public YamlConfigSource(String name, String source, int ordinal) {
        this(name, YamlConfigSource.stringToMap(source), ordinal);
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    private static Map<String, String> streamToMap(InputStream inputStream) throws IOException {
        Assert.checkNotNullParam((String)"inputStream", (Object)inputStream);
        TreeMap<String, String> yamlInput = new TreeMap<String, String>();
        try {
            Iterable objects = new Yaml((BaseConstructor)new StringConstructor(new LoaderOptions())).loadAll(inputStream);
            for (Object object : objects) {
                if (!(object instanceof Map)) continue;
                yamlInput.putAll(YamlConfigSource.yamlInputToMap((Map)object));
            }
            inputStream.close();
        }
        catch (Throwable t) {
            try {
                inputStream.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return yamlInput;
    }

    private static Map<String, String> stringToMap(String str) {
        TreeMap<String, String> yamlInput = new TreeMap<String, String>();
        Iterable objects = new Yaml((BaseConstructor)new StringConstructor(new LoaderOptions())).loadAll(str);
        for (Object object : objects) {
            if (!(object instanceof Map)) continue;
            yamlInput.putAll(YamlConfigSource.yamlInputToMap((Map)object));
        }
        return yamlInput;
    }

    private static Map<String, String> yamlInputToMap(Map<Object, Object> yamlInput) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        if (yamlInput != null) {
            YamlConfigSource.flattenYaml("", yamlInput, properties, false);
        }
        return properties;
    }

    private static void flattenYaml(String path, Map<Object, Object> source, Map<String, String> target, boolean indexed) {
        source.forEach((originalKey, value) -> {
            Object key = originalKey == null ? "" : originalKey.toString();
            if (((String)key).contains(".")) {
                key = "\"" + (String)key + "\"";
            }
            if (!((String)key).isEmpty() && path != null && !path.isEmpty()) {
                key = indexed ? path + (String)key : path + "." + (String)key;
            } else if (path != null && !path.isEmpty()) {
                key = path;
            }
            if (value instanceof String) {
                target.put((String)key, (String)value);
            } else if (value instanceof Map) {
                YamlConfigSource.flattenYaml((String)key, (Map)value, target, false);
            } else if (value instanceof List) {
                List list = (List)value;
                YamlConfigSource.flattenList((String)key, list, target);
                for (int i = 0; i < list.size(); ++i) {
                    YamlConfigSource.flattenYaml((String)key, Collections.singletonMap("[" + i + "]", list.get(i)), target, true);
                }
            } else if (value != null) {
                target.put((String)key, value.toString());
            }
        });
    }

    private static void flattenList(String key, List<Object> source, Map<String, String> target) {
        boolean mixed = false;
        ArrayList<String> flatten = new ArrayList<String>();
        for (Object value2 : source) {
            if (value2 instanceof String || value2 instanceof Boolean) {
                flatten.add(value2.toString());
                continue;
            }
            if (value2 == null) continue;
            mixed = true;
            break;
        }
        if (!mixed) {
            target.put((String)key, flatten.stream().map(value -> {
                StringBuilder sb = new StringBuilder();
                YamlConfigSource.escapeCommas(sb, value, 1);
                return sb.toString();
            }).collect(Collectors.joining(",")));
        } else {
            key = YamlConfigSource.class.getName() + ".filter." + (String)key;
            target.put((String)key, DUMPER.dump(Collections.singletonMap(((String)key).substring(((String)key).lastIndexOf(".") + 1), source)));
        }
    }

    private static void escapeCommas(StringBuilder b, String src, int escapeLevel) {
        int cp;
        for (int i = 0; i < src.length(); i += Character.charCount(cp)) {
            cp = src.codePointAt(i);
            if (cp == 92 || cp == 44) {
                for (int j = 0; j < escapeLevel; ++j) {
                    b.append('\\');
                }
            }
            b.appendCodePoint(cp);
        }
    }

    private static Set<String> filterPropertyNames(Map<String, String> source) {
        HashSet<String> filteredKeys = new HashSet<String>();
        for (String key : new HashSet<String>(source.keySet())) {
            if (key.startsWith(YamlConfigSource.class.getName() + ".filter.")) {
                String originalKey = key.substring(55);
                source.put(originalKey, source.remove(key));
                continue;
            }
            filteredKeys.add(key);
        }
        return filteredKeys;
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.FOLDED);
        DUMPER = new Yaml(dumperOptions);
    }

    private static class StringConstructor
    extends SafeConstructor {
        public StringConstructor(LoaderOptions loadingConfig) {
            super(loadingConfig);
            this.yamlConstructors.put(Tag.INT, new SafeConstructor.ConstructYamlStr((SafeConstructor)this));
            this.yamlConstructors.put(Tag.FLOAT, new SafeConstructor.ConstructYamlStr((SafeConstructor)this));
            this.yamlConstructors.put(Tag.TIMESTAMP, new SafeConstructor.ConstructYamlStr((SafeConstructor)this));
        }
    }
}

