/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.AbstractConfigSource;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;

    EnvConfigSource() {
        super("EnvConfigSource", 300);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(System::getenv));
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        Map<String, String> properties = this.getProperties();
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = this.replaceNonAlphanumericByUnderscores(name);
        value = properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return properties.get(sanitizedName.toUpperCase());
    }

    private String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }
}

