/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigSourceInterceptorContext;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 8138651532357898263L;
    static final Comparator<ConfigSource> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigSource>(){

        @Override
        public int compare(ConfigSource o1, ConfigSource o2) {
            int res = Integer.compare(o2.getOrdinal(), o1.getOrdinal());
            return res != 0 ? res : o2.getName().compareTo(o1.getName());
        }
    };
    private final AtomicReference<ConfigSources> configSources;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();

    SmallRyeConfig(SmallRyeConfigBuilder builder) {
        this.configSources = new AtomicReference<ConfigSources>(new ConfigSources(this.buildConfigSources(builder), this.buildInterceptors(builder)));
        this.converters = this.buildConverters(builder);
    }

    @Deprecated
    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSources = new AtomicReference<ConfigSources>(new ConfigSources(configSources, this.buildInterceptors(new SmallRyeConfigBuilder())));
        this.converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    private List<ConfigSource> buildConfigSources(SmallRyeConfigBuilder builder) {
        ArrayList<ConfigSource> sourcesToBuild = new ArrayList<ConfigSource>(builder.getSources());
        if (builder.isAddDiscoveredSources()) {
            sourcesToBuild.addAll(builder.discoverSources());
        }
        if (builder.isAddDefaultSources()) {
            sourcesToBuild.addAll(builder.getDefaultSources());
        }
        Function<ConfigSource, ConfigSource> sourceWrappersToBuild = builder.getSourceWrappers();
        ListIterator<ConfigSource> it = sourcesToBuild.listIterator();
        while (it.hasNext()) {
            it.set(sourceWrappersToBuild.apply((ConfigSource)it.next()));
        }
        return sourcesToBuild;
    }

    private List<SmallRyeConfigBuilder.InterceptorWithPriority> buildInterceptors(SmallRyeConfigBuilder builder) {
        ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors = new ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority>(builder.getInterceptors());
        if (builder.isAddDiscoveredInterceptors()) {
            interceptors.addAll(builder.discoverInterceptors());
        }
        if (builder.isAddDefaultInterceptors()) {
            interceptors.addAll(builder.getDefaultInterceptors());
        }
        return interceptors;
    }

    private Map<Type, Converter<?>> buildConverters(SmallRyeConfigBuilder builder) {
        HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority> convertersToBuild = new HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority>(builder.getConverters());
        if (builder.isAddDiscoveredConverters()) {
            for (Converter<?> converter : builder.discoverConverters()) {
                Type type2 = Converters.getConverterType(converter.getClass());
                if (type2 == null) {
                    throw ConfigMessages.msg.unableToAddConverter(converter);
                }
                SmallRyeConfigBuilder.addConverter(type2, converter, convertersToBuild);
            }
        }
        ConcurrentHashMap converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        convertersToBuild.forEach((type, converterWithPriority) -> converters.put((Type)type, converterWithPriority.getConverter()));
        return converters;
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
    }

    public <T> T getValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getConverter(aClass));
    }

    public <T> T getValue(String name, Converter<T> converter) {
        Object converted;
        String value = this.getRawValue(name);
        if (value != null) {
            converted = converter.convert(value);
        } else {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw ConfigMessages.msg.propertyNotFound(name);
            }
        }
        if (converted == null) {
            throw ConfigMessages.msg.propertyNotFound(name);
        }
        return (T)converted;
    }

    public boolean rawValueEquals(String name, String expected) {
        return Objects.equals(expected, this.getRawValue(name));
    }

    @Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
    public ConfigValue getConfigValue(String name) {
        ConfigValue configValue = this.configSources.get().getInterceptorChain().proceed(name);
        return configValue != null ? configValue : ConfigValue.builder().withName(name).build();
    }

    public String getRawValue(String name) {
        ConfigValue configValue = this.getConfigValue(name);
        return configValue != null && configValue.getValue() != null ? configValue.getValue() : null;
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getOptionalConverter(aClass));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        this.configSources.get().getInterceptorChain().iterateNames().forEachRemaining(names::add);
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources.get().getSources();
    }

    @Deprecated
    public void addConfigSource(ConfigSource configSource) {
        this.configSources.updateAndGet(configSources -> {
            List<ConfigSource> currentSources = configSources.getSources();
            int oldSize = currentSources.size();
            List<ConfigSource> newSources = Arrays.asList(currentSources.toArray(new ConfigSource[oldSize + 1]));
            newSources.set(oldSize, configSource);
            return new ConfigSources(newSources, (ConfigSources)configSources);
        });
    }

    public <T> T convert(String value, Class<T> asType) {
        return (T)(value != null ? this.getConverter(asType).convert(value) : null);
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        return this.optionalConverters.computeIfAbsent(asType, clazz -> Converters.newOptionalConverter(this.getConverter((Class)clazz)));
    }

    public <T> Converter<T> getConverter(Class<T> asType) {
        Converter<?> exactConverter = this.converters.get(asType);
        if (exactConverter != null) {
            return exactConverter;
        }
        if (asType.isPrimitive()) {
            return this.getConverter(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            return Converters.newArrayConverter(this.getConverter(asType.getComponentType()), asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> {
            Converter conv = ImplicitConverters.getConverter((Class)clazz);
            if (conv == null) {
                throw ConfigMessages.msg.noRegisteredConverter(asType);
            }
            return conv;
        });
    }

    private static class ConfigSources
    implements Serializable {
        private static final long serialVersionUID = 3483018375584151712L;
        private final List<ConfigSource> sources;
        private final List<ConfigSourceInterceptor> interceptors;
        private final ConfigSourceInterceptorContext interceptorChain;

        ConfigSources(List<ConfigSource> sources, List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors) {
            int i;
            sources.sort(CONFIG_SOURCE_COMPARATOR);
            interceptors.sort(Comparator.comparingInt(SmallRyeConfigBuilder.InterceptorWithPriority::getPriority).reversed());
            ArrayList<ConfigSourceInterceptor> initializedInterceptors = new ArrayList<ConfigSourceInterceptor>();
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (i = sources.size() - 1; i >= 0; --i) {
                current = new SmallRyeConfigSourceInterceptorContext(SmallRyeConfigSourceInterceptor.configSourceInterceptor(sources.get(i)), current);
            }
            for (i = interceptors.size() - 1; i >= 0; --i) {
                ConfigSourceInterceptor interceptor = interceptors.get(i).getInterceptor(current);
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current);
                initializedInterceptors.add(interceptor);
            }
            this.sources = Collections.unmodifiableList(sources);
            this.interceptors = Collections.unmodifiableList(initializedInterceptors);
            this.interceptorChain = current;
        }

        ConfigSources(List<ConfigSource> sources, ConfigSources configSources) {
            int i;
            sources.sort(CONFIG_SOURCE_COMPARATOR);
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (i = sources.size() - 1; i >= 0; --i) {
                current = new SmallRyeConfigSourceInterceptorContext(SmallRyeConfigSourceInterceptor.configSourceInterceptor(sources.get(i)), current);
            }
            for (i = configSources.getInterceptors().size() - 1; i >= 0; --i) {
                current = new SmallRyeConfigSourceInterceptorContext(configSources.getInterceptors().get(i), current);
            }
            this.sources = Collections.unmodifiableList(sources);
            this.interceptors = configSources.getInterceptors();
            this.interceptorChain = current;
        }

        List<ConfigSource> getSources() {
            return this.sources;
        }

        List<ConfigSourceInterceptor> getInterceptors() {
            return this.interceptors;
        }

        ConfigSourceInterceptorContext getInterceptorChain() {
            return this.interceptorChain;
        }
    }
}

