/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.classloader.ClassDefiner;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMappingObject;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public final class ConfigMappingObjectLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ClassValue<ConfigMappingObjectHolder> CACHE = new ClassValue<ConfigMappingObjectHolder>(){

        @Override
        protected ConfigMappingObjectHolder computeValue(Class<?> type) {
            return new ConfigMappingObjectHolder(ConfigMappingObjectLoader.getImplementationClass(type));
        }
    };

    public static ConfigMappingMetadata getConfigMappingMetadata(Class<?> interfaceType) {
        return ConfigMappingInterface.getConfigurationInterface(interfaceType);
    }

    static <T> T configMappingObject(Class<T> interfaceType, ConfigMappingContext configMappingContext) {
        ConfigMappingObject instance;
        try {
            Constructor<? extends ConfigMappingObject> constructor = CACHE.get(interfaceType).getImplementationClass().getDeclaredConstructor(ConfigMappingContext.class);
            instance = constructor.newInstance(configMappingContext);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return interfaceType.cast(instance);
    }

    static <T> Class<? extends ConfigMappingObject> getImplementationClass(Class<T> interfaceType) {
        ConfigMappingMetadata mappingMetadata = ConfigMappingObjectLoader.getConfigMappingMetadata(interfaceType);
        try {
            return interfaceType.getClassLoader().loadClass(mappingMetadata.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ConfigMappingObjectLoader.createMappingObjectClass(mappingMetadata.getClassName(), mappingMetadata.getClassBytes());
        }
    }

    static Class<? extends ConfigMappingObject> createMappingObjectClass(String className, byte[] classBytes) {
        return ClassDefiner.defineClass((MethodHandles.Lookup)LOOKUP, ConfigMappingObjectLoader.class, (String)className, (byte[])classBytes);
    }

    private static final class ConfigMappingObjectHolder {
        private final Class<? extends ConfigMappingObject> implementationClass;

        ConfigMappingObjectHolder(Class<? extends ConfigMappingObject> implementationClass) {
            this.implementationClass = implementationClass;
        }

        public Class<? extends ConfigMappingObject> getImplementationClass() {
            return this.implementationClass;
        }
    }
}

