/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public final class ConfigMappings
implements Serializable {
    private static final long serialVersionUID = -7790784345796818526L;
    private final Map<Class<?>, Map<String, ConfigMappingObject>> mappings;

    ConfigMappings() {
        this(new HashMap());
    }

    ConfigMappings(Map<Class<?>, Map<String, ConfigMappingObject>> mappings) {
        this.mappings = mappings;
    }

    void registerConfigMappings(Map<Class<?>, Map<String, ConfigMappingObject>> mappings) {
        this.mappings.putAll(mappings);
    }

    public void registerConfigMappings(SmallRyeConfig config, Set<ConfigMappingWithPrefix> mappings) throws ConfigValidationException {
        ConfigMappingProvider.Builder builder = ConfigMappingProvider.builder();
        for (ConfigMappingWithPrefix mapping : mappings) {
            builder.addRoot(mapping.getPrefix(), mapping.getKlass());
        }
        ConfigMappingProvider mappingProvider = builder.build();
        for (ConfigSource configSource : config.getConfigSources()) {
            if (!(configSource instanceof DefaultValuesConfigSource)) continue;
            DefaultValuesConfigSource defaultValuesConfigSource = (DefaultValuesConfigSource)configSource;
            defaultValuesConfigSource.registerDefaults(mappingProvider.getDefaultValues());
        }
        mappingProvider.mapConfiguration(config, this);
    }

    <T> T getConfigMapping(Class<T> type) {
        return this.getConfigMapping(type, ConfigMappings.getPrefix(type));
    }

    <T> T getConfigMapping(Class<T> type, String prefix) {
        if (prefix == null) {
            return this.getConfigMapping(type);
        }
        ConfigMappingObject configMappingObject = (ConfigMappingObject)this.mappings.getOrDefault(type, Collections.emptyMap()).get(prefix);
        if (configMappingObject == null) {
            throw ConfigMessages.msg.mappingNotFound(type.getName(), prefix);
        }
        return type.cast(configMappingObject);
    }

    static String getPrefix(Class<?> type) {
        return Optional.ofNullable(type.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix).orElse("");
    }

    public static final class ConfigMappingWithPrefix {
        private final Class<?> klass;
        private final String prefix;

        public ConfigMappingWithPrefix(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public static ConfigMappingWithPrefix configMappingWithPrefix(Class<?> klass, String prefix) {
            return new ConfigMappingWithPrefix(klass, prefix);
        }
    }
}

