/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.InvalidObjectException;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRCFG", length=5)
interface ConfigMessages {
    public static final ConfigMessages msg = (ConfigMessages)Messages.getBundle(ConfigMessages.class);

    @Message(id=0, value="The file %s was not found")
    public IllegalStateException fileNotFound(String var1);

    @Message(id=1, value="Failure while loading microprofile-config.properties files")
    public IllegalStateException failedToLoadConfig(@Cause Throwable var1);

    @Message(id=2, value="%s can not be converted to a Character")
    public IllegalArgumentException failedCharacterConversion(String var1);

    @Message(id=3, value="Converter %s must be parameterized with a single type")
    public IllegalStateException singleTypeConverter(String var1);

    @Message(id=4, value="%s is not an array type")
    public IllegalArgumentException notArrayType(String var1);

    @Message(id=5, value="Value does not match pattern %s (value was \"%s\")")
    public IllegalArgumentException valueNotMatchPattern(Pattern var1, String var2);

    @Message(id=6, value="Value must not be less than %s (value was \"%s\")")
    public IllegalArgumentException lessThanMinimumValue(Object var1, String var2);

    @Message(id=7, value="Value must not be less than or equal to %s (value was \"%s\")")
    public IllegalArgumentException lessThanEqualToMinimumValue(Object var1, String var2);

    @Message(id=8, value="Value must not be greater than %s (value was \"%s\")")
    public IllegalArgumentException greaterThanMaximumValue(Object var1, String var2);

    @Message(id=9, value="Value must not be greater than or equal to %s (value was \"%s\")")
    public IllegalArgumentException greaterThanEqualToMaximumValue(Object var1, String var2);

    @Message(id=10, value="Unknown converter ID: %s")
    public InvalidObjectException unknownConverterId(int var1);

    @Message(id=11, value="Could not expand value %s in property %s")
    public NoSuchElementException expandingElementNotFound(String var1, String var2);

    @Message(id=12, value="Can not add converter %s that is not parameterized with a type")
    public IllegalStateException unableToAddConverter(Converter<?> var1);

    @Message(id=13, value="No Converter registered for %s")
    public IllegalArgumentException noRegisteredConverter(Class<?> var1);

    @Message(id=14, value="Property %s not found")
    public NoSuchElementException propertyNotFound(String var1);

    @Message(id=15, value="No configuration is available for this class loader")
    public IllegalStateException noConfigForClassloader();

    @Message(id=16, value="config cannot be null")
    public IllegalArgumentException configIsNull();

    @Message(id=17, value="Configuration already registered for the given class loader")
    public IllegalStateException configAlreadyRegistered();

    @Message(id=18, value="Malformed \\uxxxx encoding")
    public IllegalArgumentException malformedEncoding();

    @Message(id=19, value="Failed to create new instance from Converter constructor")
    public IllegalArgumentException constructorConverterFailure(@Cause Throwable var1);

    @Message(id=20, value="Failed to convert value with static method")
    public IllegalArgumentException staticMethodConverterFailure(@Cause Throwable var1);

    @Message(id=21, value="Converter class %s not found")
    public IllegalArgumentException classConverterNotFound(@Cause Throwable var1, String var2);

    @Message(id=22, value="Host, %s, not found")
    public IllegalArgumentException unknownHost(@Cause Throwable var1, String var2);

    @Message(id=23, value="Array type being converted is unknown")
    public IllegalArgumentException unknownArrayType();

    @Message(id=24, value="Not allowed to access secret key %s")
    public SecurityException notAllowed(String var1);

    @Message(id=25, value="Recursive expression expansion is too deep for %s")
    public IllegalArgumentException expressionExpansionTooDepth(String var1);

    @Message(id=26, value="%s cannot be converted into a UUID")
    public IllegalArgumentException malformedUUID(@Cause Throwable var1, String var2);

    @Message(id=27, value="Could not find a mapping for %s with prefix %s")
    public NoSuchElementException mappingNotFound(String var1, String var2);
}

