/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.AbstractConfigSource;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    EnvConfigSource() {
        super("EnvConfigSource", 300);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(System::getenv));
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        String cachedValue = this.cache.get(name);
        if (cachedValue != null) {
            return cachedValue;
        }
        Map<String, String> properties = this.getProperties();
        String value = properties.get(name);
        if (value != null) {
            this.cache.put(name, value);
            return value;
        }
        String sanitizedName = EnvConfigSource.replaceNonAlphanumericByUnderscores(name);
        value = properties.get(sanitizedName);
        if (value != null) {
            this.cache.put(name, value);
            return value;
        }
        value = properties.get(sanitizedName.toUpperCase());
        if (value != null) {
            this.cache.put(name, value);
            return value;
        }
        return null;
    }

    private static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }
}

