/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.KeyMap;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.SecretKeysConfigSourceInterceptor;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SysPropConfigSource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfigBuilder
implements ConfigBuilder {
    private static final String META_INF_MICROPROFILE_CONFIG_PROPERTIES = "META-INF/microprofile-config.properties";
    private static final String WEB_INF_MICROPROFILE_CONFIG_PROPERTIES = "WEB-INF/classes/META-INF/microprofile-config.properties";
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private Function<ConfigSource, ConfigSource> sourceWrappers = UnaryOperator.identity();
    private final Map<Type, ConverterWithPriority> converters = new HashMap<Type, ConverterWithPriority>();
    private String profile = null;
    private final Set<String> secretKeys = new HashSet<String>();
    private final List<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
    private final KeyMap<String> defaultValues = new KeyMap();
    private final ConfigMappingProvider.Builder mappingsBuilder = ConfigMappingProvider.builder();
    private ClassLoader classLoader = SecuritySupport.getContextClassLoader();
    private boolean addDefaultSources = false;
    private boolean addDefaultInterceptors = false;
    private boolean addDiscoveredSources = false;
    private boolean addDiscoveredConverters = false;
    private boolean addDiscoveredInterceptors = false;

    public SmallRyeConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredInterceptors() {
        this.addDiscoveredInterceptors = true;
        return this;
    }

    List<ConfigSource> discoverSources() {
        ArrayList<ConfigSource> discoveredSources = new ArrayList<ConfigSource>();
        ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.classLoader);
        configSourceLoader.forEach(discoveredSources::add);
        ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.classLoader);
        configSourceProviderLoader.forEach(configSourceProvider -> configSourceProvider.getConfigSources(this.classLoader).forEach(discoveredSources::add));
        ServiceLoader<ConfigSourceFactory> configSourceFactoryLoader = ServiceLoader.load(ConfigSourceFactory.class, this.classLoader);
        configSourceFactoryLoader.forEach(factory -> discoveredSources.add(new ConfigurableConfigSource((ConfigSourceFactory)factory)));
        return discoveredSources;
    }

    List<Converter<?>> discoverConverters() {
        ArrayList discoveredConverters = new ArrayList();
        ServiceLoader.load(Converter.class, this.classLoader).forEach(discoveredConverters::add);
        return discoveredConverters;
    }

    List<InterceptorWithPriority> discoverInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        ServiceLoader<ConfigSourceInterceptor> interceptorLoader = ServiceLoader.load(ConfigSourceInterceptor.class, this.classLoader);
        interceptorLoader.forEach(interceptor -> interceptors.add(new InterceptorWithPriority((ConfigSourceInterceptor)interceptor)));
        ServiceLoader<ConfigSourceInterceptorFactory> interceptorFactoryLoader = ServiceLoader.load(ConfigSourceInterceptorFactory.class, this.classLoader);
        interceptorFactoryLoader.forEach(interceptor -> interceptors.add(new InterceptorWithPriority((ConfigSourceInterceptorFactory)interceptor)));
        return interceptors;
    }

    public SmallRyeConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    protected List<ConfigSource> getDefaultSources() {
        ArrayList<ConfigSource> defaultSources = new ArrayList<ConfigSource>();
        defaultSources.add((ConfigSource)new EnvConfigSource());
        defaultSources.add((ConfigSource)new SysPropConfigSource());
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(META_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(WEB_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        return defaultSources;
    }

    public SmallRyeConfigBuilder addDefaultInterceptors() {
        this.addDefaultInterceptors = true;
        return this;
    }

    List<InterceptorWithPriority> getDefaultInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return SmallRyeConfigBuilder.this.profile != null ? new ProfileConfigSourceInterceptor(SmallRyeConfigBuilder.this.profile) : new ProfileConfigSourceInterceptor(context);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3600);
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ExpressionConfigSourceInterceptor()));
        interceptors.add(new InterceptorWithPriority(new SecretKeysConfigSourceInterceptor(this.secretKeys)));
        return interceptors;
    }

    public SmallRyeConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSource ... configSources) {
        Collections.addAll(this.sources, configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(Collection<ConfigSource> configSources) {
        this.sources.addAll(configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSourceFactory ... configSourceFactories) {
        Stream.of(configSourceFactories).forEach(configSourceFactory -> this.sources.add(new ConfigurableConfigSource((ConfigSourceFactory)configSourceFactory)));
        return this;
    }

    public SmallRyeConfigBuilder withInterceptors(ConfigSourceInterceptor ... interceptors) {
        this.interceptors.addAll(Stream.of(interceptors).map(x$0 -> new InterceptorWithPriority((ConfigSourceInterceptor)x$0)).collect(Collectors.toList()));
        return this;
    }

    public SmallRyeConfigBuilder withInterceptorFactories(ConfigSourceInterceptorFactory ... interceptorFactories) {
        this.interceptors.addAll(Stream.of(interceptorFactories).map(x$0 -> new InterceptorWithPriority((ConfigSourceInterceptorFactory)x$0)).collect(Collectors.toList()));
        return this;
    }

    public SmallRyeConfigBuilder withProfile(String profile) {
        this.addDefaultInterceptors();
        this.profile = profile;
        return this;
    }

    public SmallRyeConfigBuilder withSecretKeys(String ... keys) {
        this.secretKeys.addAll(Stream.of(keys).collect(Collectors.toSet()));
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValue(String name, String value) {
        this.defaultValues.findOrAdd(name).putRootValue(value);
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValues(Map<String, String> defaultValues) {
        defaultValues.forEach((key, value) -> this.defaultValues.findOrAdd((String)key).putRootValue((String)value));
        return this;
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass) {
        return this.withMapping(klass, ConfigMappings.getPrefix(klass));
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass, String prefix) {
        this.mappingsBuilder.addRoot(prefix, klass);
        return this;
    }

    public SmallRyeConfigBuilder withMappingIgnore(String path) {
        this.mappingsBuilder.addIgnored(path);
        return this;
    }

    public SmallRyeConfigBuilder withConverters(Converter<?>[] converters) {
        for (Converter<?> converter : converters) {
            Type type = Converters.getConverterType(converter.getClass());
            if (type == null) {
                throw ConfigMessages.msg.unableToAddConverter(converter);
            }
            SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, this.converters);
        }
        return this;
    }

    public <T> SmallRyeConfigBuilder withConverter(Class<T> type, int priority, Converter<T> converter) {
        SmallRyeConfigBuilder.addConverter(type, priority, converter, this.converters);
        return this;
    }

    @Deprecated
    public SmallRyeConfigBuilder withWrapper(UnaryOperator<ConfigSource> wrapper) {
        this.sourceWrappers = this.sourceWrappers.andThen(wrapper);
        return this;
    }

    static void addConverter(Type type, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, converters);
    }

    static void addConverter(Type type, int priority, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        ConverterWithPriority oldConverter = converters.get(type);
        if (oldConverter == null || priority > oldConverter.priority) {
            converters.put(type, new ConverterWithPriority(converter, priority));
        }
    }

    private static int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    protected List<ConfigSource> getSources() {
        return this.sources;
    }

    @Deprecated
    Function<ConfigSource, ConfigSource> getSourceWrappers() {
        return this.sourceWrappers;
    }

    protected Map<Type, ConverterWithPriority> getConverters() {
        return this.converters;
    }

    List<InterceptorWithPriority> getInterceptors() {
        return this.interceptors;
    }

    KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    protected boolean isAddDefaultSources() {
        return this.addDefaultSources;
    }

    boolean isAddDefaultInterceptors() {
        return this.addDefaultInterceptors;
    }

    protected boolean isAddDiscoveredSources() {
        return this.addDiscoveredSources;
    }

    protected boolean isAddDiscoveredConverters() {
        return this.addDiscoveredConverters;
    }

    boolean isAddDiscoveredInterceptors() {
        return this.addDiscoveredInterceptors;
    }

    public SmallRyeConfig build() {
        ConfigMappingProvider mappingProvider = this.mappingsBuilder.build();
        KeyMap<String> mappingProviderDefaultValues = mappingProvider.getDefaultValues();
        mappingProviderDefaultValues.forEach(this.defaultValues::putIfAbsent);
        try {
            ConfigMappings configMappings = new ConfigMappings();
            SmallRyeConfig config = new SmallRyeConfig(this, configMappings);
            mappingProvider.mapConfiguration(config, configMappings);
            return config;
        }
        catch (ConfigValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    static class InterceptorWithPriority {
        private static final OptionalInt OPTIONAL_DEFAULT_PRIORITY = OptionalInt.of(5000);
        private final ConfigSourceInterceptorFactory factory;
        private final int priority;

        private InterceptorWithPriority(final ConfigSourceInterceptor interceptor) {
            this(new ConfigSourceInterceptorFactory(){

                @Override
                public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                    return interceptor;
                }

                @Override
                public OptionalInt getPriority() {
                    OptionalInt priority = ConfigSourceInterceptorFactory.super.getPriority();
                    if (priority.isPresent()) {
                        return priority;
                    }
                    return Optional.ofNullable(interceptor.getClass().getAnnotation(Priority.class)).map(priority1 -> OptionalInt.of(priority1.value())).orElse(OPTIONAL_DEFAULT_PRIORITY);
                }
            });
        }

        private InterceptorWithPriority(ConfigSourceInterceptorFactory factory) {
            this.factory = factory;
            this.priority = factory.getPriority().orElse(5000);
        }

        ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
            return this.factory.getInterceptor(context);
        }

        int getPriority() {
            return this.priority;
        }
    }

    static class ConverterWithPriority {
        private final Converter<?> converter;
        private final int priority;

        private ConverterWithPriority(Converter<?> converter, int priority) {
            this.converter = converter;
            this.priority = priority;
        }

        Converter<?> getConverter() {
            return this.converter;
        }
    }
}

