/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Priority;

@Priority(value=3600)
public class ProfileConfigSourceInterceptor
implements ConfigSourceInterceptor {
    public static final String SMALLRYE_PROFILE = "smallrye.config.profile";
    private static final long serialVersionUID = -6305289277993917313L;
    private static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = (o1, o2) -> {
        int res = Integer.compare(o2.getConfigSourceOrdinal(), o1.getConfigSourceOrdinal());
        if (res != 0) {
            return res;
        }
        if (o1.getConfigSourceName() != null && o2.getConfigSourceName() != null) {
            return o2.getConfigSourceName().compareTo(o1.getConfigSourceName());
        }
        return res;
    };
    private final String[] profiles;

    public ProfileConfigSourceInterceptor(String profile) {
        if (profile != null) {
            List convertedProfiles = (List)Converters.newCollectionConverter(Converters.STRING_CONVERTER, ArrayList::new).convert(profile);
            Collections.reverse(convertedProfiles);
            this.profiles = convertedProfiles.toArray(new String[0]);
        } else {
            this.profiles = new String[0];
        }
    }

    public ProfileConfigSourceInterceptor(ConfigSourceInterceptorContext context) {
        this(context, SMALLRYE_PROFILE);
    }

    public ProfileConfigSourceInterceptor(ConfigSourceInterceptorContext context, String profileConfigName) {
        this((String)Optional.ofNullable(context.proceed(profileConfigName)).map(ConfigValue::getValue).orElse(null));
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String normalizeName;
        ConfigValue profileValue;
        if (this.profiles.length > 0 && (profileValue = this.getProfileValue(context, normalizeName = this.normalizeName(name))) != null) {
            try {
                ConfigValue originalValue = context.proceed(normalizeName);
                if (originalValue != null && CONFIG_SOURCE_COMPARATOR.compare(profileValue, originalValue) > 0) {
                    return originalValue;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return profileValue.withName(normalizeName);
        }
        return context.proceed(name);
    }

    public ConfigValue getProfileValue(ConfigSourceInterceptorContext context, String normalizeName) {
        for (String profile : this.profiles) {
            ConfigValue profileValue = context.proceed("%" + profile + "." + normalizeName);
            if (profileValue == null) continue;
            return profileValue;
        }
        return null;
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet names = new HashSet();
        context.iterateNames().forEachRemaining(name -> names.add(this.normalizeName((String)name)));
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet values = new HashSet();
        context.iterateValues().forEachRemaining(value -> values.add(value.withName(this.normalizeName(value.getName()))));
        return values.iterator();
    }

    private String normalizeName(String name) {
        for (String profile : this.profiles) {
            if (!name.startsWith("%" + profile + ".")) continue;
            return name.substring(profile.length() + 2);
        }
        return name;
    }
}

