/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.MetadataInjectionPoint;
import io.smallrye.config.inject.SecuritySupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigMappingInjectionBean<T>
implements Bean<T> {
    private final BeanManager bm;
    private final Class<T> klass;
    private final String prefix;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();

    public ConfigMappingInjectionBean(BeanManager bm, AnnotatedType<T> type) {
        this.bm = bm;
        this.klass = type.getJavaClass();
        this.prefix = ConfigMappingInjectionBean.getConfigMappingPrefix(type);
        this.qualifiers.add((Annotation)Default.Literal.INSTANCE);
    }

    public Class<?> getBeanClass() {
        return this.klass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint injectionPoint = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new MetadataInjectionPoint(), creationalContext);
        String overridePrefix = injectionPoint.getAnnotated() != null && injectionPoint.getAnnotated().isAnnotationPresent(ConfigMapping.class) ? ConfigMappingInjectionBean.getConfigMappingPrefix(injectionPoint.getAnnotated()) : this.prefix;
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig((ClassLoader)SecuritySupport.getContextClassLoader());
        return config.getConfigMapping(this.klass, overridePrefix);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.klass);
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return this.getClass() + "_" + this.klass.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    static String getConfigMappingPrefix(Annotated annotated) {
        return Optional.ofNullable(annotated.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix).orElse("");
    }
}

