/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ConfigMappingClass
implements ConfigMappingMetadata {
    private static final ClassValue<ConfigMappingClass> cv = new ClassValue<ConfigMappingClass>(){

        @Override
        protected ConfigMappingClass computeValue(Class<?> classType) {
            return ConfigMappingClass.createConfigurationClass(classType);
        }
    };
    private static final String I_OBJECT = Type.getInternalName(Object.class);
    private static final String I_CLASS = Type.getInternalName(Class.class);
    private static final String I_FIELD = Type.getInternalName(Field.class);
    private final Class<?> classType;
    private final String interfaceName;

    static ConfigMappingClass getConfigurationClass(Class<?> classType) {
        Assert.checkNotNullParam((String)"classType", classType);
        return cv.get(classType);
    }

    private static ConfigMappingClass createConfigurationClass(Class<?> classType) {
        if (classType.isInterface() && classType.getTypeParameters().length == 0 || Modifier.isAbstract(classType.getModifiers()) || classType.isEnum()) {
            return null;
        }
        String interfaceName = classType.getPackage().getName() + "." + classType.getSimpleName() + classType.getName().hashCode() + "I";
        return new ConfigMappingClass(classType, interfaceName);
    }

    private static byte[] getClassBytes(Class<?> classType, String interfaceName) {
        Field[] declaredFields;
        Object classInstance;
        String classInternalName = Type.getInternalName(classType);
        String interfaceInternalName = interfaceName.replace('.', '/');
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1537, interfaceInternalName, null, I_OBJECT, new String[]{Type.getInternalName(ConfigMappingClassMapper.class)});
        try {
            classInstance = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            classInstance = null;
        }
        for (Field declaredField : declaredFields = classType.getDeclaredFields()) {
            AnnotationVisitor av;
            AnnotationVisitor av2;
            MethodVisitor mv = writer.visitMethod(1025, declaredField.getName(), Type.getMethodDescriptor((Type)Type.getType(declaredField.getType()), (Type[])new Type[0]), ConfigMappingClass.getSignature(declaredField), null);
            boolean hasDefault = false;
            if (declaredField.isAnnotationPresent(WithName.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                av2.visit("value", (Object)declaredField.getAnnotation(WithName.class).value());
                av2.visitEnd();
            }
            if (declaredField.isAnnotationPresent(WithDefault.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                av2.visit("value", (Object)declaredField.getAnnotation(WithDefault.class).value());
                av2.visitEnd();
                hasDefault = true;
            }
            if (declaredField.isAnnotationPresent(WithConverter.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithConverter.class) + ";", true);
                av2.visit("value", declaredField.getAnnotation(WithConverter.class).value());
                av2.visitEnd();
            }
            if (declaredField.isAnnotationPresent(ConfigProperty.class)) {
                ConfigProperty configProperty = declaredField.getAnnotation(ConfigProperty.class);
                if (!configProperty.name().isEmpty()) {
                    av = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                    av.visit("value", (Object)configProperty.name());
                    av.visitEnd();
                }
                if (!configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    av = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                    av.visit("value", (Object)configProperty.defaultValue());
                    av.visitEnd();
                    hasDefault = true;
                }
            }
            if (!hasDefault && classInstance != null) {
                try {
                    declaredField.setAccessible(true);
                    Object defaultValue = declaredField.get(classInstance);
                    if (ConfigMappingClass.hasDefaultValue(declaredField.getType(), defaultValue)) {
                        av = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                        av.visit("value", (Object)defaultValue.toString());
                        av.visitEnd();
                    }
                }
                catch (IllegalAccessException defaultValue) {
                    // empty catch block
                }
            }
            mv.visitEnd();
        }
        MethodVisitor ctor = writer.visitMethod(1, "map", "()L" + I_OBJECT + ";", null, null);
        Label ctorStart = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitTypeInsn(187, classInternalName);
        ctor.visitInsn(89);
        ctor.visitMethodInsn(183, classInternalName, "<init>", "()V", false);
        ctor.visitVarInsn(58, 1);
        for (Field declaredField : declaredFields) {
            if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isVolatile(declaredField.getModifiers()) || Modifier.isFinal(declaredField.getModifiers())) continue;
            String name = declaredField.getName();
            Class<?> type = declaredField.getType();
            if (Modifier.isPublic(declaredField.getModifiers())) {
                ctor.visitVarInsn(25, 1);
                ctor.visitVarInsn(25, 0);
                ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
                ctor.visitFieldInsn(181, classInternalName, name, Type.getDescriptor(type));
                continue;
            }
            ctor.visitLdcInsn((Object)Type.getType(classType));
            ctor.visitLdcInsn((Object)name);
            ctor.visitMethodInsn(182, I_CLASS, "getDeclaredField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            ctor.visitVarInsn(58, 2);
            ctor.visitVarInsn(25, 2);
            ctor.visitInsn(4);
            ctor.visitMethodInsn(182, I_FIELD, "setAccessible", "(Z)V", false);
            ctor.visitVarInsn(25, 2);
            ctor.visitVarInsn(25, 1);
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
            switch (Type.getType(type).getSort()) {
                case 1: {
                    ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    ctor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    ctor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    ctor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    ctor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 6: {
                    ctor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 7: {
                    ctor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 8: {
                    ctor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                }
            }
            ctor.visitMethodInsn(182, I_FIELD, "set", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), false);
        }
        ctor.visitVarInsn(25, 1);
        ctor.visitInsn(176);
        ctor.visitMaxs(2, 2);
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static String getSignature(Field field) {
        String typeName = field.getGenericType().getTypeName();
        if (typeName.indexOf(60) != -1 && typeName.indexOf(62) != -1) {
            String signature = "()L" + typeName.replace(".", "/");
            signature = signature.replace("<", "<L");
            signature = signature.replace(">", ";>;");
            return signature;
        }
        return null;
    }

    private static boolean hasDefaultValue(Class<?> klass, Object value) {
        if (value == null) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Number && value.equals(0)) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Boolean && value.equals(Boolean.FALSE)) {
            return false;
        }
        return !klass.isPrimitive() || !(value instanceof Character) || !value.equals(0);
    }

    public ConfigMappingClass(Class<?> classType, String interfaceName) {
        this.classType = classType;
        this.interfaceName = interfaceName;
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.classType;
    }

    @Override
    public String getClassName() {
        return this.interfaceName;
    }

    @Override
    public byte[] getClassBytes() {
        return ConfigMappingClass.getClassBytes(this.classType, this.interfaceName);
    }
}

