/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.expression.Expression;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import java.util.Optional;
import javax.annotation.Priority;

@Priority(value=3800)
public class ExpressionConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -539336551011916218L;
    private static final int MAX_DEPTH = 32;
    private final boolean enabled;

    public ExpressionConfigSourceInterceptor() {
        this.enabled = true;
    }

    public ExpressionConfigSourceInterceptor(ConfigSourceInterceptorContext context) {
        this.enabled = Optional.ofNullable(context.proceed("mp.config.property.expressions.enabled")).map(ConfigValue::getValue).map(Boolean::valueOf).orElse(Boolean.TRUE);
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        return this.getValue(context, name, 1);
    }

    private ConfigValue getValue(ConfigSourceInterceptorContext context, String name, int depth) {
        if (depth == 32) {
            throw ConfigMessages.msg.expressionExpansionTooDepth(name);
        }
        ConfigValue configValue = context.proceed(name);
        if (!Expressions.isEnabled() || !this.enabled) {
            return configValue;
        }
        if (configValue == null) {
            return null;
        }
        Expression expression = Expression.compile((String)configValue.getValue().replaceAll("\\\\,", "\\\\\\\\,"), (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM, Expression.Flag.ESCAPES, Expression.Flag.NO_SMART_BRACES});
        String expanded = expression.evaluate((resolveContext, stringBuilder) -> {
            ConfigValue resolve = this.getValue(context, resolveContext.getKey(), depth + 1);
            if (resolve != null) {
                stringBuilder.append(resolve.getValue());
            } else if (resolveContext.hasDefault()) {
                resolveContext.expandDefault();
            } else {
                throw ConfigMessages.msg.expandingElementNotFound(resolveContext.getKey(), configValue.getName());
            }
        });
        return configValue.withValue(expanded);
    }
}

